﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace ahid {
namespace hdr {

class HdrMutex
{

    NN_DISALLOW_COPY(HdrMutex);
    NN_DISALLOW_MOVE(HdrMutex);

public:

    HdrMutex() NN_NOEXCEPT {};
    ~HdrMutex() NN_NOEXCEPT {};

    Result  Initialize() NN_NOEXCEPT;
    Result  Finalize() NN_NOEXCEPT;
    Result  Lock() NN_NOEXCEPT;
    Result  Unlock() NN_NOEXCEPT;

private:

    nn::os::MutexType m_Mutex;
};

}   // namespace hdr
}   // namespace ahid
}   // namespace nn
