﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace ahid {
namespace hdr {

enum
{
    HdrHandleCountMax       = HdrEntriesCountMax,
    HdrHandleInstanceMask   = 0x00ffffff,
    HdrHandleIndexShift     = 24,
};

class HdrHandle
{

    NN_DISALLOW_COPY(HdrHandle);
    NN_DISALLOW_MOVE(HdrHandle);

public:

    HdrHandle() NN_NOEXCEPT {};
    ~HdrHandle() NN_NOEXCEPT {};

    Result          Initialize();
    Result          Finalize();
    Result          AttachHandle(DeviceHandle* pHandle);
    Result          DetachHandle(DeviceHandle handle);
    Result          GetIndexForHandle(DeviceHandle handle, int* pIndex);
    Result          GetHandleForIndex(int index, DeviceHandle* pHandle);

private:

    uint32_t        m_Instance[HdrHandleCountMax];
    bool            m_IsAttached[HdrHandleCountMax];

    bool            HandleIsValid(DeviceHandle handle);
    int             HandleIndex(DeviceHandle handle);
    DeviceHandle    EncodeHandle(int index);
};

}   // namespace hdr
}   // namespace ahid
}   // namespace nn
