﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    ahid_Hdr.cpp
 * @brief   HDR Top Level
 */
#include <cstdio>
#include <cstring>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/util/util_IntrusiveList.h>

#include <nn/os.h>
#include <nn/os/os_SdkThreadCommon.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_InterruptEvent.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_MemoryFence.h>

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/impl/sf_StaticOneAllocator.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_NativeHandle.h>

#include <nn/ahid/ahid_ResultPrivate.h>
#include <nn/ahid/ahid_ResultPublic.h>

#define ASSERT_RESULT   NN_ABORT_UNLESS(result.IsSuccess(), "%s %d\n", __FILE__, __LINE__);

#include <nn/ahid/hdr/hdr.h>

#include "ahid_HdrMutex.h"
#include "ahid_HdrHandle.h"
#include "ahid_HdrDevice.h"
#include "ahid_HdrSession.h"
#include "ahid_HdrServer.h"

namespace nn {
namespace ahid {
namespace hdr {

Result HdrInitialize() NN_NOEXCEPT;
Result HdrFinalize() NN_NOEXCEPT;
nn::sf::SharedPointer<nn::ahid::hdr::ISession> HdrGetDfcSession() NN_NOEXCEPT;

} // end of namespace hdr
} // end of namespace ahid
} // end of namespace nn
