﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ahid_Hdr.h"

namespace nn {
namespace ahid {
namespace hdr {
namespace {

HdrServer g_HdrServer;

} // end of namesapce

//////////////////////////////////////////////////////////////////////////////
Result HdrInitialize() NN_NOEXCEPT
{
    return g_HdrServer.Initialize();
}


//////////////////////////////////////////////////////////////////////////////
Result HdrFinalize() NN_NOEXCEPT
{
    return g_HdrServer.Finalize();
}


//////////////////////////////////////////////////////////////////////////////
nn::sf::SharedPointer<nn::ahid::hdr::ISession> HdrGetDfcSession() NN_NOEXCEPT
{
    return g_HdrServer.GetDfcSession();
}



} // end of namespace hdr
} // end of namespace ahid
} // end of namespace nn




