﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/am/am_Shim.h>
#include <nn/applet/applet_Types.h>
#include <nn/applet/applet_Result.h>
#include <nn/ae/ae_IdlePolicyApi.h>
#include <nn/ae/ae_Result.h>
#include <nn/ae/ae_Types.h>


namespace nn { namespace ae {

//-----------------------------------------------------------------------------
//  無操作状態検出時の制御パラメータのリストア
//
void LoadAndApplyIdlePolicySettings() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetGlobalStateController()->LoadAndApplyIdlePolicySettings());
}

//-----------------------------------------------------------------------------
//  ユーザの操作があったことを明示的に宣言
//
void ReportUserIsActive() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetSelfController()->ReportUserIsActive());
}

//-----------------------------------------------------------------------------

}}  // namespace nn::ae

