﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/am/am_Shim.h>
#include <nn/am/am_Result.h>

#include <nn/ae/ae_HdcpApi.h>
#include <nn/ae/ae_Result.h>
#include <nn/ae/ae_Types.h>

namespace nn { namespace ae {

//-----------------------------------------------------------------------------
// HDCP 認証失敗イベントの取得
//
void GetHdcpAuthenticationFailedEvent(os::SystemEvent* pEvent) NN_NOEXCEPT
{
    sf::NativeHandle nativeHandle;
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetGlobalStateController()->GetHdcpAuthenticationFailedEvent(&nativeHandle));
    pEvent->AttachReadableHandle(nativeHandle.GetOsHandle(), nativeHandle.IsManaged(), os::EventClearMode_ManualClear);
    nativeHandle.Detach();
}

}}  // namespace nn::ae
