﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Result.h>
#include <nn/account/json/account_JsonAdaptor.h>
#include <nn/account/ndas/account_AuthenticationCache.h>

#include <cstddef>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace account { namespace ndas {

class ApplicationAuthenticationAdaptor
{
    NN_DISALLOW_COPY(ApplicationAuthenticationAdaptor);

private:
    ApplicationAuthenticationCache& m_AppAuthCache;
    detail::ApplicationInfo m_AppInfo;

    // 欲しいエントリ
    json::LookupEntry m_ExpirationEntry;
    json::LookupEntry m_TokenEntry;
    json::LookupEntry m_ErrorCodeEntry;
    json::LookupEntry m_ErrorMsgEntry;
    json::LookupEntry m_NasClientIdEntry;
    json::LookupEntry m_NasRedirectUriEntry;

    // 正常時の応答
    int64_t m_ExpirationAbs;
    detail::Uuid m_TokenCacheId;
    nas::NasClientInfo m_NasClientInfo;

    // エラー
    Result m_IoResult;
    uint16_t m_ErrorCode;

    bool CanContinue() const NN_NOEXCEPT
    {
        return m_IoResult.IsSuccess();
    }

public:
    typedef json::JsonPath<8, 64> JsonPathType;

public:
    ApplicationAuthenticationAdaptor(
        ApplicationAuthenticationCache& appAuthCache,
        const detail::ApplicationInfo& appInfo) NN_NOEXCEPT;
    ~ApplicationAuthenticationAdaptor() NN_NOEXCEPT;

    // アダプタの内容をモデルに反映する
    // (JSON に限らず、ダウンロードしたファイルなどの適用処理もここで行う)
    Result Adapt(int32_t httpCode) NN_NOEXCEPT;

    void Update(const JsonPathType& jsonPath, int64_t value) NN_NOEXCEPT;
    void Update(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT;
    // 以下考慮しない入力
    void Update(const JsonPathType&, std::nullptr_t) NN_NOEXCEPT {} // NOP
    void Update(const JsonPathType&, bool) NN_NOEXCEPT {} // NOP
    void Update(const JsonPathType&, uint64_t) NN_NOEXCEPT {} // NOP
    void Update(const JsonPathType&, double) NN_NOEXCEPT {} // NOP
    void NotifyObjectBegin(const JsonPathType&) NN_NOEXCEPT {} // NOP
    void NotifyObjectEnd(const JsonPathType&) NN_NOEXCEPT {} // NOP
};

}}}
