﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/account/account_Types.h>
#include <nn/account/nas/account_NasTypes.h>

namespace nn { namespace account { namespace nas {

class NasResourceResolver
{
private:
    static NasClientInfo m_ClientInfoForAccountSystem;

    static bool m_Initialized;
    static void InitializeImplicitly() NN_NOEXCEPT;

public:
    static int GetUrlForToken(char* url, size_t bufferSize) NN_NOEXCEPT;
    static int GetUrlForAuthorizationRequest(char* url, size_t bufferSize) NN_NOEXCEPT;
    static int GetUrlForUserResource(char* url, size_t bufferSize) NN_NOEXCEPT;

    static NasClientInfo GetClientIdForAccountSystem() NN_NOEXCEPT;
    static Scope GetScopeForAccountSystem() NN_NOEXCEPT;
    static Scope GetScopeForOp2Membership() NN_NOEXCEPT;
};

}}} // ~namespace nn::account::baas
