﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/nas/account_NasInternalTypes.h>
#include <nn/account/detail/account_LocalStorage.h>
#include <nn/account/http/account_OAuthTypes.h>
#include <nn/account/account_Types.h>
#include <nn/account/account_NintendoAccountTypes.h>

#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace account { namespace nas {

class NasCredentialHolder
{
public:
    static bool HasCredential(const NintendoAccountId& naId, const detail::AbstractLocalStorage& storage) NN_NOEXCEPT;

    static Result LoadCodeVerifier(
        http::CodeVerifier* pOut,
        const NintendoAccountId& naId, const detail::AbstractLocalStorage& storage) NN_NOEXCEPT;

    static Result LoadIdToken(
        size_t* pOutSizeActual, char* buffer, size_t bufferSize,
        const NintendoAccountId& naId, const detail::AbstractLocalStorage& storage) NN_NOEXCEPT;

    static Result LoadRefreshToken(
        size_t* pOutSizeActual, char* buffer, size_t bufferSize,
        const NintendoAccountId& naId, const detail::AbstractLocalStorage& storage) NN_NOEXCEPT;

    static Result Store(
        const NintendoAccountId& naId, const NasCredentialCache& cache, const http::CodeVerifier& codeVerifier,
        const detail::AbstractLocalStorage& storage,
        void *workBuffer, size_t workBufferSize) NN_NOEXCEPT;

    static void Delete(const NintendoAccountId& naId, const detail::AbstractLocalStorage& storage) NN_NOEXCEPT;
};

}}} // ~namespace nn::account::baas
