﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/http/account_SimpleDownloader.h>

#include <nn/account/account_ResultPrivate.h>
#include <nn/account/http/account_ResultForHttp.h>
#include <nn/util/util_ScopeExit.h>

#include "account_HttpUtil.h"

namespace nn { namespace account { namespace http {

/* --------------------------------------------------------------------------------------------
    Callback
 */
size_t SimpleDownloader::WriteFunction(char* ptr, size_t unitBytes, size_t count, void* pContext) NN_NOEXCEPT
{
    const auto InputBytes = unitBytes * count;
    // Obj が受信可能であることの検査
    auto& obj = *reinterpret_cast<SimpleDownloader*>(pContext);
    if (true
        && !obj.IsCancelled()
        && !obj.m_BufferInfo.failure
        && InputBytes <= obj.m_BufferInfo.total - obj.m_BufferInfo.used)
    {
        auto address = reinterpret_cast<uintptr_t>(obj.m_BufferInfo.address) + obj.m_BufferInfo.used;
        std::memcpy(reinterpret_cast<void*>(address), ptr, InputBytes);
        obj.m_BufferInfo.used += InputBytes;
        return InputBytes;
    }
    obj.m_BufferInfo.failure = true;
    return 0;
}

/* --------------------------------------------------------------------------------------------
    SimpleDownloader API
 */

SimpleDownloader::SimpleDownloader(CURL* curlHandle, const util::Cancelable* pCancellable) NN_NOEXCEPT
    : WebApiAccessorBase(curlHandle, pCancellable)
{
    m_BufferInfo.address = nullptr;
    m_BufferInfo.total = 0u;
    m_BufferInfo.used = 0u;
    m_BufferInfo.failure = false;
}
Result SimpleDownloader::Initialize(void* buffer, size_t bufferSize) NN_NOEXCEPT
{
    NN_SDK_ASSERT(buffer != nullptr);
    NN_SDK_ASSERT(bufferSize > 0);
    NN_RESULT_DO(WebApiAccessorBase::SetDefault());
    NN_RESULT_DO(WebApiAccessorBase::SetWriteFunction(WriteFunction, this));
    NN_RESULT_DO(WebApiAccessorBase::SetUserAgent(GetUserAgent()));
    NN_RESULT_DO(WebApiAccessorBase::SetErrorHandler(DefaultErrorHandler));
    m_BufferInfo.address = buffer;
    m_BufferInfo.total = bufferSize;
    m_BufferInfo.used = 0;
    m_BufferInfo.failure = false;
    NN_RESULT_SUCCESS;
}
Result SimpleDownloader::Invoke(size_t* pOutSizeActual) NN_NOEXCEPT
{
    NN_UTIL_SCOPE_EXIT
    {
        WebApiAccessorBase::Reset();
    };
    NN_SDK_ASSERT(m_BufferInfo.address != nullptr);

    NN_RESULT_TRY(WebApiAccessorBase::Perform())
    NN_RESULT_CATCH(ResultCurlErrorWriteError)
    {
        if (m_BufferInfo.failure)
        {
            NN_RESULT_THROW(ResultInsufficientBuffer());
        }
        NN_RESULT_RETHROW;
    }
    NN_RESULT_END_TRY

    NN_RESULT_DO(WebApiAccessorBase::GetResult());
    *pOutSizeActual = m_BufferInfo.used;
    NN_RESULT_SUCCESS;
}

}}} // ~namespace nn::account::http
