﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Types.h>

#include <atomic>

#include <nn/nn_Common.h>

namespace nn { namespace account { namespace baas {

class BaasResourceResolver
{
public:
    static int GetUrlForClientLogin(char* url, size_t bufferSize) NN_NOEXCEPT;
    static int GetUrlForUserLogin(char* url, size_t bufferSize) NN_NOEXCEPT;
    static int GetUrlForFederationLogin(char* url, size_t bufferSize) NN_NOEXCEPT;
    static int GetUrlForUserRegistry(char* url, size_t bufferSize) NN_NOEXCEPT;
    static int GetUrlForUser(char* url, size_t bufferSize, const NetworkServiceAccountId& userId) NN_NOEXCEPT;
    static int GetUrlForDeviceAccount(char* url, size_t bufferSize, const NetworkServiceAccountId& userId, uint64_t daId) NN_NOEXCEPT;

    static int GetUrlForLink(char* url, size_t bufferSize, const NetworkServiceAccountId& userId) NN_NOEXCEPT;
    static int GetUrlForUnlink(char* url, size_t bufferSize, const NetworkServiceAccountId& userId) NN_NOEXCEPT;

    static int GetUrlForImage(char* url, size_t bufferSize) NN_NOEXCEPT;

    static int GetUrlForChannel(char* url, size_t bufferSize, const NetworkServiceAccountId& userId, uint64_t daId) NN_NOEXCEPT;
};

}}} // ~namespace nn::account::baas
