﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "account_BaasResourceResolver.h"

#include <cstring>

#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/util/util_FormatString.h>

namespace nn { namespace account { namespace baas {
namespace {

const char Fqdn[] = "https://e0d67c509fb203858ebcb2fe3f88c2aa.baas.nintendo.com";

} // ~namespace nn::account::baas::<anonymous>

int BaasResourceResolver::GetUrlForClientLogin(char* url, size_t bufferSize) NN_NOEXCEPT
{
    auto l = nn::util::SNPrintf(url, bufferSize, "%s/1.0.0/application/token", Fqdn);
    NN_ABORT_UNLESS(l < static_cast<int>(bufferSize)); // 終端チェック
    return l;
}
int BaasResourceResolver::GetUrlForUserLogin(char* url, size_t bufferSize) NN_NOEXCEPT
{
    auto l = nn::util::SNPrintf(url, bufferSize, "%s/1.0.0/login", Fqdn);
    NN_ABORT_UNLESS(l < static_cast<int>(bufferSize));
    return l;
}
int BaasResourceResolver::GetUrlForFederationLogin(char* url, size_t bufferSize) NN_NOEXCEPT
{
    auto l = nn::util::SNPrintf(url, bufferSize, "%s/1.0.0/federation", Fqdn);
    NN_ABORT_UNLESS(l < static_cast<int>(bufferSize));
    return l;
}
int BaasResourceResolver::GetUrlForUserRegistry(char* url, size_t bufferSize) NN_NOEXCEPT
{
    auto l = nn::util::SNPrintf(url, bufferSize, "%s/1.0.0/users", Fqdn);
    NN_ABORT_UNLESS(l < static_cast<int>(bufferSize));
    return l;
}
int BaasResourceResolver::GetUrlForUser(char* url, size_t bufferSize, const NetworkServiceAccountId& userId) NN_NOEXCEPT
{
    auto l = nn::util::SNPrintf(url, bufferSize, "%s/1.0.0/users/%016llx", Fqdn, userId.id);
    NN_ABORT_UNLESS(l < static_cast<int>(bufferSize));
    return l;
}
int BaasResourceResolver::GetUrlForDeviceAccount(char* url, size_t bufferSize, const NetworkServiceAccountId& userId, uint64_t daId) NN_NOEXCEPT
{
    auto l = nn::util::SNPrintf(url, bufferSize, "%s/1.0.0/users/%016llx/device_accounts/%016llx", Fqdn, userId.id, daId);
    NN_ABORT_UNLESS(l < static_cast<int>(bufferSize));
    return l;
}
int BaasResourceResolver::GetUrlForLink(char* url, size_t bufferSize, const NetworkServiceAccountId& userId) NN_NOEXCEPT
{
    auto l = nn::util::SNPrintf(url, bufferSize, "%s/1.0.0/users/%016llx/link", Fqdn, userId.id);
    NN_ABORT_UNLESS(l < static_cast<int>(bufferSize));
    return l;
}
int BaasResourceResolver::GetUrlForUnlink(char* url, size_t bufferSize, const NetworkServiceAccountId& userId) NN_NOEXCEPT
{
    auto l = nn::util::SNPrintf(url, bufferSize, "%s/1.0.0/users/%016llx/unlink", Fqdn, userId.id);
    NN_ABORT_UNLESS(l < static_cast<int>(bufferSize));
    return l;
}
int BaasResourceResolver::GetUrlForImage(char* url, size_t bufferSize) NN_NOEXCEPT
{
    auto l = nn::util::SNPrintf(url, bufferSize, "%s/1.0.0/image_upload", Fqdn);
    NN_ABORT_UNLESS(l < static_cast<int>(bufferSize));
    return l;
}
int BaasResourceResolver::GetUrlForChannel(char* url, size_t bufferSize, const NetworkServiceAccountId& userId, uint64_t daId) NN_NOEXCEPT
{
    auto l = nn::util::SNPrintf(url, bufferSize, "%s/1.0.0/push_channels/%016llx/%016llx", Fqdn, userId.id, daId);
    NN_ABORT_UNLESS(l < static_cast<int>(bufferSize));
    return l;
}

}}} // ~namespace nn::account::baas
