﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/baas/account_BaasTypes.h>
#include <nn/account/account_Types.h>
#include "account_BaasProblemDetails.h"

#include <nn/npns/npns_Types.h>

namespace nn {
namespace account {
namespace baas {

class ChannelAdaptor
    : public BaasCommonAdaptor<8, 64>
{
    NN_DISALLOW_COPY(ChannelAdaptor);

private:
    typedef BaasCommonAdaptor<8, 64> Base;

    const NetworkServiceAccountId m_UserId;
    const uint64_t m_DaId;

    json::LookupEntry m_UserIdEntry;
    json::LookupEntry m_DaIdEntry;
    json::LookupEntry m_ServiceEntry;
    json::LookupEntry m_NtEntry;
    bool m_Adapted;

    npns::NotificationToken m_Nt;

public:
    typedef Base::JsonPathType JsonPathType;

protected:
    virtual Result AdaptImpl() NN_NOEXCEPT final NN_OVERRIDE;
    virtual bool UpdateImpl(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT final NN_OVERRIDE;

public:
    ChannelAdaptor(const NetworkServiceAccountId& userId,uint64_t daId) NN_NOEXCEPT;

    npns::NotificationToken GetNt() const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(m_Adapted);
        return m_Nt;
    }
};

} // ~namespace nn::account::baas
}
}
