﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "account_BaasChannelAdaptor.h"

#include <nn/account/account_ResultPrivate.h>
#include <nn/account/baas/account_ResultForBaas.h>

#include "../detail/account_ByteUtil.h"

namespace nn {
namespace account {
namespace baas {

#define NN_ACCOUNT_PRINT_ENTRY_STATE(e) \
        NN_SDK_LOG("    %s : %s\n", (e)? "+": "-", (e).path)

ChannelAdaptor::ChannelAdaptor(const NetworkServiceAccountId& userId, uint64_t daId) NN_NOEXCEPT
    : m_UserId(userId)
    , m_DaId(daId)
    , m_UserIdEntry("$.userId")
    , m_DaIdEntry("$.deviceAccountId")
    , m_ServiceEntry("$.service")
    , m_NtEntry("$.deviceToken")
    , m_Adapted(false)
{
}

Result ChannelAdaptor::AdaptImpl() NN_NOEXCEPT
{
    if (!(m_UserIdEntry && m_DaIdEntry && m_ServiceEntry && m_NtEntry))
    {
        NN_SDK_LOG(
            "[nn::account] -----------------------------------------------\n"
            "  Error: BaaS UserResource failed\n");
        NN_ACCOUNT_PRINT_ENTRY_STATE(m_DaIdEntry);
        NN_ACCOUNT_PRINT_ENTRY_STATE(m_UserIdEntry);
        NN_ACCOUNT_PRINT_ENTRY_STATE(m_ServiceEntry);
        NN_ACCOUNT_PRINT_ENTRY_STATE(m_NtEntry);
        NN_RESULT_THROW(ResultBaasDataBroken());
    }
    m_Adapted = true;
    NN_RESULT_SUCCESS;
}

bool ChannelAdaptor::UpdateImpl(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT
{
    if (m_UserIdEntry.CanAccept(jsonPath))
    {
        if (valueLength == sizeof(uint64_t) * 2)
        {
            auto id = detail::ExtractHexadecimal<uint64_t>(value, valueLength);
            if (id == m_UserId.id)
            {
                m_UserIdEntry.MarkAccepted();
            }
        }
        return true;
    }
    else if (m_DaIdEntry.CanAccept(jsonPath))
    {
        if (valueLength == sizeof(uint64_t) * 2)
        {
            auto id = detail::ExtractHexadecimal<uint64_t>(value, valueLength);
            if (id == m_DaId)
            {
                m_DaIdEntry.MarkAccepted();
            }
        }
        return true;
    }
    else if (m_ServiceEntry.CanAccept(jsonPath))
    {
        if (strncmp(value, "npns", sizeof("npns")) == 0)
        {
            m_ServiceEntry.MarkAccepted();
        }
        return true;
    }
    else if (m_NtEntry.CanAccept(jsonPath))
    {
        if (valueLength <= sizeof(m_Nt.data))
        {
            std::strncpy(m_Nt.data, value, sizeof(m_Nt.data));
            m_NtEntry.MarkAccepted();
        }
    }
    return false;
}

#undef NN_ACCOUNT_PRINT_ENTRY_STATE

} // ~namespace nn::account::baas
}
}
