﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/account_ApiNetworkServiceLicense.h>

#include <nn/nn_SdkAssert.h>
#include <nn/account/baas/account_Interface.sfdl.h>
#include <nn/account/detail/account_IAsyncNetworkServiceLicenseKindContext.sfdl.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace account {

AsyncNetworkServiceLicenseKindContext::AsyncNetworkServiceLicenseKindContext(detail::IAsyncNetworkServiceLicenseKindContext* ptr) NN_NOEXCEPT
    : AsyncContext(ptr)
{
    NN_SDK_REQUIRES_NOT_NULL(ptr);
}

AsyncNetworkServiceLicenseKindContext::AsyncNetworkServiceLicenseKindContext() NN_NOEXCEPT
    : AsyncContext()
{
}

AsyncNetworkServiceLicenseKindContext::AsyncNetworkServiceLicenseKindContext(AsyncNetworkServiceLicenseKindContext&& rhs) NN_NOEXCEPT
    : AsyncContext(std::move(rhs))
{
}

AsyncNetworkServiceLicenseKindContext& AsyncNetworkServiceLicenseKindContext::operator=(AsyncNetworkServiceLicenseKindContext&& rhs) NN_NOEXCEPT
{
    AsyncNetworkServiceLicenseKindContext tmp(std::move(rhs));
    tmp.Swap(*this);
    return *this;
}

NetworkServiceLicenseKind AsyncNetworkServiceLicenseKindContext::GetNetworkServiceLicenseKind() NN_NOEXCEPT
{
    NN_SDK_ASSERT(GetResult().IsSuccess());

    int32_t rawLicense;
    NN_ABORT_UNLESS_RESULT_SUCCESS(reinterpret_cast<detail::IAsyncNetworkServiceLicenseKindContext*>(GetPointerUnsafe())->GetNetworkServiceLicenseKind(&rawLicense));
    switch( rawLicense )
    {
    case NetworkServiceLicenseKind_None:
    case NetworkServiceLicenseKind_Common:
        break;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
    return static_cast<NetworkServiceLicenseKind>(rawLicense);
}

Result LoadNetworkServiceLicenseKindAsync(AsyncNetworkServiceLicenseKindContext* pOut, const UserHandle& handle) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOut);

    auto ptr = reinterpret_cast<baas::IManagerForApplication*>(handle._context);
    sf::SharedPointer<detail::IAsyncNetworkServiceLicenseKindContext> asyncContextPtr;
    NN_RESULT_DO(ptr->LoadNetworkServiceLicenseKindAsync(&asyncContextPtr));

    *pOut = AsyncNetworkServiceLicenseKindContext(asyncContextPtr.Detach());

    NN_RESULT_SUCCESS;
}

}} // ~namespace nn::account
