﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cctype>
#include <limits>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/account/account_Types.h>

namespace nn {
namespace account {
namespace {

#if 0
static const char Iv[] = "0000-0000-0000-0000-0000-0";
const auto Length = sizeof(Iv) - 1;
NN_STATIC_ASSERT(Length == 26);
#endif

template <int Modulus, int Weight, typename T>
int CalculateCheckDigitImpl(T raw) NN_NOEXCEPT
{
    decltype(raw) checkDigit = 0;
    bool isOdd = true;
    while (raw != 0)
    {
        const auto Digit = (raw % Modulus);
        raw /= Modulus;
        checkDigit += (isOdd ? Weight * Digit : Digit);
        isOdd = !isOdd;
    }
    checkDigit = (Modulus - (checkDigit % Modulus));
    return (checkDigit == Modulus ? 0 : static_cast<int>(checkDigit));
}

} // ~namespace nn::account::<anonymous>

int CalculateCheckDigit(const NetworkServiceAccountId& nsaId) NN_NOEXCEPT
{
    return CalculateCheckDigitImpl<10, 3>(nsaId.id);
}

#if 0
void ConvertNetworkServiceAccountIdForCustomerService(char* buffer, size_t bufferSize, const NetworkServiceAccountId& nsaId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(buffer);
    NN_SDK_REQUIRES(bufferSize >= Length + 1);

    std::memcpy(buffer, Iv, Length + 1);

    auto raw = nsaId.id;
    decltype(raw) checkDigit = 0;

    int place = 0;
    bool isOdd = true;
    while (raw != 0)
    {
        const auto Digit = (raw % 10);
        raw /= 10;
        checkDigit += (isOdd ? 3 * Digit : Digit);
        isOdd = !isOdd;

        const auto BufferIndex = ((Length - 2) - (place + (place / 4)) - 1);
        NN_SDK_ASSERT(BufferIndex >= 0);
        ++ place;
        buffer[BufferIndex] = (static_cast<char>(Digit) + '0');
    }
    checkDigit = (10 - (checkDigit % 10));
    NN_SDK_ASSERT(checkDigit <= std::numeric_limits<char>::max());
    buffer[Length - 1] = (checkDigit == 10 ? '0' : static_cast<char>(checkDigit) + '0');
}

bool DeconvertNetworkServiceAccountIdForCustomerService(NetworkServiceAccountId * pOut, const char* buffer, size_t bufferSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(buffer);
    NN_SDK_REQUIRES(bufferSize >= Length + 1);
    NN_SDK_ASSERT(strnlen(buffer, bufferSize) == Length);

    uint64_t raw = 0;
    decltype(raw) checkDigit = 0;

    int place = 0;
    bool isOdd = false;
    while (place < 20)
    {
        const auto BufferIndex = (place + (place / 4));
        NN_SDK_ASSERT(BufferIndex >= 0);
        ++ place;
        const auto C = buffer[BufferIndex];
        NN_SDK_ASSERT(std::isdigit(C));

        const auto Digit = (C - '0');
        if (!((10 * raw) + Digit >= raw))
        {
            return false;
        }
        raw = (10 * raw) + Digit;
        checkDigit += (isOdd ? 3 * Digit : Digit);
        isOdd = !isOdd;
    }
    checkDigit = (10 - (checkDigit % 10));
    NN_SDK_ASSERT(checkDigit <= std::numeric_limits<char>::max());
    if (!((buffer[Length - 1] - '0') == (checkDigit == 10 ? 0 : static_cast<char>(checkDigit))))
    {
        return false;
    }

    NetworkServiceAccountId id = {raw};
    *pOut = id;
    return true;
}
#endif

}} // ~namespace nn::account
