﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/account_ApiForSystemServices.h>
#include <nn/account/account_CachedNintendoAccountInfo.h>

#include <utility>

namespace nn {
namespace account {
namespace
{
template <size_t SizeLimit>
inline const char* GetStringFieldImpl(size_t* pOutSize, const char (&data)[SizeLimit]) NN_NOEXCEPT
{
    auto s = strnlen(data, SizeLimit) + 1;
    NN_SDK_ASSERT(s <= SizeLimit);
    *pOutSize = s;
    return data;
}
} // ~namespace nn::account::<anonymous>

CachedNintendoAccountInfo::CachedNintendoAccountInfo() NN_NOEXCEPT
{
}
const char* CachedNintendoAccountInfo::GetBirthday(size_t* pOutBytes) const NN_NOEXCEPT
{
    return GetStringFieldImpl(pOutBytes, m_Base.birthday);
}
const char* CachedNintendoAccountInfo::GetGender(size_t* pOutBytes) const NN_NOEXCEPT
{
    return GetStringFieldImpl(pOutBytes, m_Base.gender);
}
const char* CachedNintendoAccountInfo::GetCountry(size_t* pOutBytes) const NN_NOEXCEPT
{
    return GetStringFieldImpl(pOutBytes, m_Base.country);
}

CachedNintendoAccountInfoForSystemService::CachedNintendoAccountInfoForSystemService() NN_NOEXCEPT
{
    m_Id.id = 0x00ull;
}
const NintendoAccountId& CachedNintendoAccountInfoForSystemService::GetId() const NN_NOEXCEPT
{
    return m_Id;
}
bool CachedNintendoAccountInfoForSystemService::IsChild() const NN_NOEXCEPT
{
    return m_Base.isChild;
}
const char* CachedNintendoAccountInfoForSystemService::GetScreenName(size_t* pOutBytes) const NN_NOEXCEPT
{
    return GetStringFieldImpl(pOutBytes, m_Base.screenName);
}
const char* CachedNintendoAccountInfoForSystemService::GetEmailAddress(size_t* pOutBytes) const NN_NOEXCEPT
{
    return GetStringFieldImpl(pOutBytes, m_Base.email);
}
const char* CachedNintendoAccountInfoForSystemService::GetLoginId(size_t* pOutBytes) const NN_NOEXCEPT
{
    return GetStringFieldImpl(pOutBytes, m_Base.loginId);
}
const char* CachedNintendoAccountInfoForSystemService::GetBirthday(size_t* pOutBytes) const NN_NOEXCEPT
{
    return GetStringFieldImpl(pOutBytes, m_Base.birthday);
}
const char* CachedNintendoAccountInfoForSystemService::GetGender(size_t* pOutBytes) const NN_NOEXCEPT
{
    return GetStringFieldImpl(pOutBytes, m_Base.gender);
}
const char* CachedNintendoAccountInfoForSystemService::GetCountry(size_t* pOutBytes) const NN_NOEXCEPT
{
    return GetStringFieldImpl(pOutBytes, m_Base.country);
}
const char* CachedNintendoAccountInfoForSystemService::GetRegion(size_t* pOutBytes) const NN_NOEXCEPT
{
    return GetStringFieldImpl(pOutBytes, m_Base.region);
}
const char* CachedNintendoAccountInfoForSystemService::GetLanguage(size_t* pOutBytes) const NN_NOEXCEPT
{
    return GetStringFieldImpl(pOutBytes, m_Base.language);
}
bool CachedNintendoAccountInfoForSystemService::GetAnalyticsOptedInFlag() const NN_NOEXCEPT
{
    return m_Base.analyticsOptedIn;
}
bool CachedNintendoAccountInfoForSystemService::IsLinkedWithNintendoNetwork() const NN_NOEXCEPT
{
    return m_Base.isNnLinked;
}

} // ~namespace nn::account
}
