﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * 温度検知機能に関する関数群
 */

#include <nn/os.h>
#include <nn/nn_Common.h>

#include <nn/i2c/i2c.h>
#include <nn/gpio/gpio.h>

#include <nnd/tmp451/tmp451.h>

namespace nnd {
namespace tmp451 {
namespace detail {

nn::Result GetPin1DetectionSettings(Temperature* pOutRemoteLimit, Temperature* pOutLocalLimit, BusSessions bus) NN_NOEXCEPT;
nn::Result SetPin1DetectionSettings(Temperature remoteLimit, Temperature localLimit, BusSessions bus) NN_NOEXCEPT;
nn::Result GetPin2DetectionSettings(Temperature* pOutRemoteLowLimit, Temperature* pOutRemoteHighLimit,
                                    Temperature* pOutLocalLowLimit, Temperature* pOutLocalHighLimit,
                                    DetectionMode* pOutDetection, BusSessions bus) NN_NOEXCEPT;
nn::Result SetPin2DetectionSettings(Temperature remoteLowLimit, Temperature remoteHighLimit,
                                    Temperature locaLowlLimit, Temperature localHighLimit,
                                    DetectionMode mode, BusSessions bus) NN_NOEXCEPT;
nn::Result BindInterrupt(nn::os::SystemEventType* pEvent, SignalPin pin, BusSessions bus) NN_NOEXCEPT;
nn::Result UnbindInterrupt(SignalPin pin, BusSessions bus) NN_NOEXCEPT;
void SetInterruptEnable(bool enable, SignalPin pin, BusSessions bus) NN_NOEXCEPT;
nn::Result GetThermHysterisis(uint8_t* pOutHysterisis, BusSessions bus) NN_NOEXCEPT;
nn::Result SetThermHysterisis(uint8_t hysterisis, BusSessions bus) NN_NOEXCEPT;
nn::Result GetConsecutiveAlert(AlertConsecutive* pOutConsecutive, BusSessions bus) NN_NOEXCEPT;
nn::Result SetConsecutiveAlert(AlertConsecutive consecutive, BusSessions bus) NN_NOEXCEPT;

// Pin1 に対してシステムイベントを紐付けする
nn::Result BindInterruptPin1(nn::os::SystemEventType* pEvent, BusSessions bus) NN_NOEXCEPT;

// Pin2 に対してシステムイベントを紐付けする
nn::Result BindInterruptPin2(nn::os::SystemEventType* pEvent, BusSessions bus) NN_NOEXCEPT;

// Pin1 に紐付いたシステムイベントを解除する
nn::Result UnbindInterruptPin1(BusSessions bus) NN_NOEXCEPT;

// Pin2 に紐付いたシステムイベントを解除する
nn::Result UnbindInterruptPin2(BusSessions bus) NN_NOEXCEPT;

// Pin1 に紐付いた割り込みの許可状態を設定する
void SetInterruptPin1Enable(bool enable, BusSessions bus) NN_NOEXCEPT;

// Pin2 に紐付いた割り込みの許可状態を設定する
void SetInterruptPin2Enable(bool enable, BusSessions bus) NN_NOEXCEPT;

} // detail
} // tmp451
} // nnd
