﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_TimeSpan.h>

#include <nn/result/result_HandlingUtility.h>

#include <nnd/lsm6ds3/lsm6ds3.h>

namespace nnd {
namespace lsm6ds3 {

nn::Result Initialize() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

void Finalize() NN_NOEXCEPT
{
}

void ResetDevice() NN_NOEXCEPT
{
}

void GetState(SixAxisSensorCountState* pOutState) NN_NOEXCEPT
{
    NN_UNUSED(pOutState);
}

void GetStateForPeriodicReceiveMode(SixAxisSensorCountState* pOutState) NN_NOEXCEPT
{
    NN_UNUSED(pOutState);
}

void StartPeriodicReceiveMode(nn::TimeSpan interval, char* receiveBuffer, size_t receiveBufferLength) NN_NOEXCEPT
{
    NN_UNUSED(interval);
    NN_UNUSED(receiveBuffer);
    NN_UNUSED(receiveBufferLength);
}

void StopPeriodicReceiveMode() NN_NOEXCEPT
{
}

void GetNoiseReductionFilter(bool* pOutEnable) NN_NOEXCEPT
{
    NN_UNUSED(pOutEnable);
}

void SetNoiseReductionFilter(bool enable) NN_NOEXCEPT
{
    NN_UNUSED(enable);
}

// Accelerometer
void StartAccelerometer() NN_NOEXCEPT
{
}

void StopAccelerometer() NN_NOEXCEPT
{
}

void GetAccelerometerFsr(AccelerometerFsr* pOutAccelerometerFsr) NN_NOEXCEPT
{
    NN_UNUSED(pOutAccelerometerFsr);
}

void SetAccelerometerFsr(AccelerometerFsr accelerometerFsr) NN_NOEXCEPT
{
    NN_UNUSED(accelerometerFsr);
}

void GetAccelerometerOdr(AccelerometerOdr* pOutAccelerometerOdr) NN_NOEXCEPT
{
    NN_UNUSED(pOutAccelerometerOdr);
}

void SetAccelerometerOdr(AccelerometerOdr accelerometerOdr) NN_NOEXCEPT
{
    NN_UNUSED(accelerometerOdr);
}

// Gyroscope
void StartGyroscope() NN_NOEXCEPT
{
}

void StopGyroscope() NN_NOEXCEPT
{
}

void GetGyroscopeFsr(GyroscopeFsr* pOutGyroscopeFsr) NN_NOEXCEPT
{
    NN_UNUSED(pOutGyroscopeFsr);
}

void SetGyroscopeFsr(GyroscopeFsr gyroscopeFsr) NN_NOEXCEPT
{
    NN_UNUSED(gyroscopeFsr);
}

void GetGyroscopeOdr(GyroscopeOdr* pOutGyroscopeOdr) NN_NOEXCEPT
{
    NN_UNUSED(pOutGyroscopeOdr);
}

void SetGyroscopeOdr(GyroscopeOdr gyroscopeOdr) NN_NOEXCEPT
{
    NN_UNUSED(gyroscopeOdr);
}

} // lsm6ds3
} // nnd
