﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ビット操作周りのユーティリティ関数
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

namespace nnd {
namespace lsm6ds3 {
namespace detail {

//!< Overwrite partly on specified register
NN_FORCEINLINE void Modify8(uint8_t* reg, uint8_t value, uint8_t mask) NN_NOEXCEPT
{
    auto temp = *reg;
    temp &= ~mask;
    temp |= value;
    *reg = temp;
}

//!< Turn on specified bits
NN_FORCEINLINE void SetBitOn8(uint8_t* reg, uint8_t flags) NN_NOEXCEPT
{
    auto temp = *reg;
    temp |= flags;
    *reg = temp;
}

//!< Turn off specified bits
NN_FORCEINLINE void SetBitOff8(uint8_t* reg, uint8_t flags) NN_NOEXCEPT
{
    auto temp = *reg;
    temp &= ~flags;
    *reg = temp;
}

AccelerometerFsr ConvertToAccelerometerFsr(AccFsrRegValue reg);
AccFsrRegValue ConvertToAccFsrRegValue(AccelerometerFsr fsr);

GyroscopeFsr ConvertToGyroscopeFsr(GyroFsrRegValue reg);
GyroFsrRegValue ConvertToGyroFsrRegValue(GyroscopeFsr fsr);

AccelerometerOdr ConvertToAccelerometerOdr(AccOdrRegValue reg);
AccOdrRegValue ConvertToAccOdrRegValue(AccelerometerOdr odr);

GyroscopeOdr ConvertToGyroscopeOdr(GyroOdrRegValue reg);
GyroOdrRegValue ConvertToGyroOdrRegValue(GyroscopeOdr odr);

} // detail
} // lsm6ds3
} // nnd
