﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sasbus/sasbus.h>

#include <nnd/lsm6ds3/lsm6ds3.h>

namespace nnd {
namespace lsm6ds3 {
namespace detail {

class Driver
{
    NN_DISALLOW_COPY(Driver);
    NN_DISALLOW_MOVE(Driver);

public:
    Driver()  NN_NOEXCEPT;
    ~Driver() NN_NOEXCEPT;

    // General
    nn::Result Initialize(int priority, int idealCoreNumber) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void ResetDevice() NN_NOEXCEPT;
    void GetState(SixAxisSensorCountState* pOutState) NN_NOEXCEPT;
    int  GetStatesForPeriodicReceiveMode(SixAxisSensorCountState* pOutState, int count) NN_NOEXCEPT;
    void StartPeriodicReceiveMode(nn::TimeSpan interval, char* receiveBuffer, size_t receiveBufferLength) NN_NOEXCEPT;
    void StopPeriodicReceiveMode() NN_NOEXCEPT;

    // Filter
    void GetNoiseReductionFilter(bool* pOutEnable) NN_NOEXCEPT;
    void SetNoiseReductionFilter(bool enable) NN_NOEXCEPT;

    // Accelerometer
    void StartAccelerometer() NN_NOEXCEPT;
    void StopAccelerometer() NN_NOEXCEPT;

    void GetAccelerometerFsr(AccelerometerFsr* pOutFsr) NN_NOEXCEPT;
    void SetAccelerometerFsr(AccelerometerFsr fsr) NN_NOEXCEPT;

    void GetAccelerometerOdr(AccelerometerOdr* pOutOdr) NN_NOEXCEPT;
    void SetAccelerometerOdr(AccelerometerOdr odr) NN_NOEXCEPT;

    // Gyroscope
    void StartGyroscope() NN_NOEXCEPT;
    void StopGyroscope() NN_NOEXCEPT;

    void GetGyroscopeFsr(GyroscopeFsr* pOutFsr) NN_NOEXCEPT;
    void SetGyroscopeFsr(GyroscopeFsr fsr) NN_NOEXCEPT;

    void GetGyroscopeOdr(GyroscopeOdr* pOutOdr) NN_NOEXCEPT;
    void SetGyroscopeOdr(GyroscopeOdr odr) NN_NOEXCEPT;

private:
    uint8_t ReadId() NN_NOEXCEPT;

private:
    uint8_t                    m_DeviceId;
    bool                       m_Initialized;
    bool                       m_IsFilterEnabled;
    nn::sasbus::Session        m_SasbusSession;
};

} // detail
} // lsm6ds3
} // nnd
