﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   lsm6ds3 のドライバで使用するデバッグ用関数です
 */

#pragma once

#include <nn/nn_SdkLog.h>

#include <nnd/lsm6ds3/lsm6ds3_Types.h>

// #define NND_LSM6DS3_DEBUG

#ifdef NND_LSM6DS3_DEBUG
#define NND_LSM6DS3_DETAIL_LOG(...) NN_SDK_LOG("nnd::lsm6ds3::detail > " __VA_ARGS__);
#else
#define NND_LSM6DS3_DETAIL_LOG(...)
#endif

namespace nnd {
namespace lsm6ds3 {
namespace detail {

// SensorCountState をダンプします
void DebugDumpSensorCountState(const nnd::lsm6ds3::SixAxisSensorCountState* pState);

} // detail
} // lsm6ds3
} // nnd
