﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
/**
 * @file
 * @brief   デバッグ用関数の実装部
 */

#include <cstring>
#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/os.h>

#include <nn/result/result_HandlingUtility.h>
#include <nnd/lsm6ds3/lsm6ds3_Types.h>
#include "lsm6ds3_Debug.h"

namespace nnd {
namespace lsm6ds3 {
namespace detail {

void DebugDumpSensorCountState(const nnd::lsm6ds3::SixAxisSensorCountState* pState)
{
    NND_LSM6DS3_DETAIL_LOG("(%04d, %04d, %04d, %04d, %04d, %04d)\n", pState->acceleration.x,
                                                                     pState->acceleration.y,
                                                                     pState->acceleration.z,
                                                                     pState->angularVelocity.x,
                                                                     pState->angularVelocity.y,
                                                                     pState->angularVelocity.z);
}


} // detail
} // lsm6ds3
} // nnd
