﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_DeviceCode.h>
#include <nn/nn_SdkAssert.h>

#include <nn/os.h>

#include <nn/i2c/driver/i2c_I2cDeviceProperty.h>
#include <nn/i2c/i2c_Type.h>

#include "i2cSkeleton_I2cBusAccessor.h"

NN_DDSF_CAST_SAFE_DEFINE(nnd::i2c::skeleton::detail::I2cBusAccessor, nn::i2c::driver::II2cDriver);

namespace nnd { namespace i2c { namespace skeleton { namespace detail {

I2cBusAccessor::I2cBusAccessor() NN_NOEXCEPT
{
    // implement me
}

void I2cBusAccessor::RegisterDeviceCode(nn::DeviceCode deviceCode) NN_NOEXCEPT
{
    // implement me if needed
    m_DeviceCode = deviceCode;
}

void I2cBusAccessor::InitializeDriver() NN_NOEXCEPT
{
    // implement me
}

nn::Result I2cBusAccessor::InitializeDevice(nn::i2c::driver::I2cDeviceProperty* pDevice) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pDevice);

    // implement me

    NN_UNUSED(pDevice);
    NN_RESULT_SUCCESS;
}

void I2cBusAccessor::FinalizeDevice(nn::i2c::driver::I2cDeviceProperty* pDevice) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pDevice);

    // implement me

    NN_UNUSED(pDevice);
}

nn::Result I2cBusAccessor::Send(nn::i2c::driver::I2cDeviceProperty* pDevice, const void* pInData,
    size_t dataBytes, nn::i2c::TransactionOption inOption) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pDevice);
    NN_SDK_REQUIRES_NOT_NULL(pInData);
    NN_SDK_REQUIRES_GREATER(dataBytes, 0);

    // implement me

    NN_UNUSED(pDevice);
    NN_UNUSED(pInData);
    NN_UNUSED(dataBytes);
    NN_UNUSED(inOption);
    NN_RESULT_SUCCESS;
}

nn::Result I2cBusAccessor::Receive(void* pOutData, nn::i2c::driver::I2cDeviceProperty* pDevice,
    size_t dataBytes, nn::i2c::TransactionOption inOption) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutData);
    NN_SDK_REQUIRES_NOT_NULL(pDevice);
    NN_SDK_REQUIRES_GREATER(dataBytes, 0);

    // implement me

    NN_UNUSED(pOutData);
    NN_UNUSED(pDevice);
    NN_UNUSED(dataBytes);
    NN_UNUSED(inOption);
    NN_RESULT_SUCCESS;
}

nn::os::SdkMutex& I2cBusAccessor::GetTransactionOrderMutex() NN_NOEXCEPT
{
    // implement me if needed
    return m_TransactionOrderMutex;
}

void I2cBusAccessor::SuspendBus() NN_NOEXCEPT
{
    // implement me
}

void I2cBusAccessor::SuspendPowerBus() NN_NOEXCEPT
{
    // implement me
}

void I2cBusAccessor::ResumeBus() NN_NOEXCEPT
{
    // implement me
}

void I2cBusAccessor::ResumePowerBus() NN_NOEXCEPT
{
    // implement me
}

const nn::DeviceCode& I2cBusAccessor::GetDeviceCode() const NN_NOEXCEPT
{
    // implement me if needed
    return m_DeviceCode;
}

}}}} // nnd::i2c::skeleton::detail
