﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_DeviceCode.h>

#include <nn/dt/dt_StringList.h>
#include <nn/dt/dt_Types.h>
#include <nn/i2c/driver/detail/dt/i2c_DeviceCodeNodeParser.h>

#include "i2cSkeleton_I2cBusAccessorManager.h"
#include "i2cSkeleton_I2cDevicePropertyManager.h"

namespace nnd { namespace i2c { namespace skeleton { namespace detail {

class DeviceCodeBusParser : public nn::i2c::driver::detail::dt::IDeviceCodeNodeParser
{
private:
    typedef nn::i2c::driver::detail::dt::IDeviceCodeNodeParser Base;

public:
    explicit DeviceCodeBusParser(I2cBusAccessorAllocator& i2cBusAccessorAllocator) NN_NOEXCEPT
        : Base({ "implement-me" })
        , m_I2cBusAccessorAllocator(i2cBusAccessorAllocator)
    {}

    template<size_t N>
    DeviceCodeBusParser(I2cBusAccessorAllocator& i2cBusAccessorAllocator, const char* const(&compatibleNames)[N]) NN_NOEXCEPT
        : Base( compatibleNames )
        , m_I2cBusAccessorAllocator(i2cBusAccessorAllocator)
    {}

private:
    virtual nn::Result OnCompatibleNodeBegin(nn::dt::Node node) NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::Result OnDeviceCodeFound(nn::DeviceCode deviceCode, nn::dt::Node node) NN_NOEXCEPT NN_OVERRIDE;

protected:
    nn::Result ParseI2cBusAccessor(I2cBusAccessor** ppOutI2cBusAccessor, const nn::dt::Node* pI2cBusNode) NN_NOEXCEPT;

protected:
    I2cBusAccessorAllocator& m_I2cBusAccessorAllocator;
    nn::dt::StringForwardList::const_iterator m_Iterator { "" };
    nn::dt::StringForwardList::const_iterator m_End { "" };
};

class DeviceCodeDeviceParser : public DeviceCodeBusParser
{
private:
    typedef DeviceCodeBusParser Base;

public:
    DeviceCodeDeviceParser(I2cBusAccessorAllocator& i2cBusAccessorAllocator, I2cDevicePropertyAllocator& i2cDevicePropertyAllocator) NN_NOEXCEPT
        : Base(i2cBusAccessorAllocator, { "implement-me" })
        , m_I2cDevicePropertyAllocator(i2cDevicePropertyAllocator)
    {}

private:
    virtual nn::Result OnDeviceCodeFound(nn::DeviceCode deviceCode, nn::dt::Node node) NN_NOEXCEPT NN_OVERRIDE;

    nn::Result ParseI2cDeviceProperty(nn::i2c::driver::I2cDeviceProperty** ppOutI2cDeviceProperty, const nn::dt::Node* pI2cDeviceNode) NN_NOEXCEPT;

private:
    I2cDevicePropertyAllocator& m_I2cDevicePropertyAllocator;
};

}}}} // nnd::i2c::skeleton::detail
