﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/util/util_IntrusiveList.h>

#include "gpioTegra_Pad.h"

namespace nnd { namespace gpio { namespace tegra { namespace detail {

    class PadAllocator
    {
    public:
        PadAllocator(PadTegra* pBuffer, int bufferCount) NN_NOEXCEPT
        {
            m_FreeList.clear();
            for ( int i = 0; i < bufferCount; ++i )
            {
                m_FreeList.push_back(pBuffer[i]);
            }
        }
        PadTegra* Alloc() NN_NOEXCEPT
        {
            if ( m_FreeList.empty() )
            {
                return nullptr;
            }
            auto p = &m_FreeList.front();
            m_FreeList.pop_front();
            return p->SafeCastToPointer<PadTegra>();
        }
        void Free(PadTegra* p) NN_NOEXCEPT
        {
            NN_SDK_ASSERT_NOT_NULL(p);
            NN_SDK_ASSERT(!p->IsLinkedToList());
            m_FreeList.push_front(*p);
        }

    private:
        PadTegra::List m_FreeList;
    };

    template<int MaxPadCount>
    class PadManager
    {
    public:
        PadManager() NN_NOEXCEPT :
            m_EntryBuffer(),
            m_Allocator(m_EntryBuffer, MaxPadCount)
        {
        }
        PadAllocator& GetAllocator() NN_NOEXCEPT
        {
            return m_Allocator;
        }

    private:
        PadTegra m_EntryBuffer[MaxPadCount];
        PadAllocator m_Allocator;
    };

}}}} // nnd::gpio::tegra::detail
