﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/devicecode/devicecode_Predefined.gpio.h>

#include <nn/gpio/driver/gpio_IGpioDriver.h>
#include <nn/gpio/driver/gpio_Pad.h>

#include <nne/wec/wec.h>

namespace nnd { namespace gpio { namespace tegra { namespace detail {

typedef int InternalGpioPadNumber;
const InternalGpioPadNumber InternalGpioPadNumberNone = -1;

const nne::wec::WakeEvent WakeEventNone = static_cast<nne::wec::WakeEvent>(-1);

const int PadPortCount = NN_DETAIL_DEVICECODE_GPIO_PORT_COUNT;

// TX1 固有の追加属性
struct PadInfo
{
    nne::wec::WakeEvent wakeEvent;

    PadInfo() NN_NOEXCEPT :
        wakeEvent(WakeEventNone)
    {}

    bool operator==(const PadInfo& rhs) const
    {
        return wakeEvent == rhs.wakeEvent;
    }
};

// TX1 固有の状態値
struct PadStatus
{
    bool isWakeActive; //!< 直近の起床要因であったか
    bool isWakeActiveTest; //!< 直近の起床要因であったか（起床要因エミュレートテスト用）

    PadStatus() NN_NOEXCEPT :
        isWakeActive(false),
        isWakeActiveTest(false)
    {}
};

class PadTegra :
    public nn::gpio::driver::Pad
{
    NN_DDSF_CAST_SAFE_DECL;

private:
    typedef nn::gpio::driver::Pad Base;

private:
    nn::util::IntrusiveListNode m_InterruptBoundListNode;
    friend class nn::util::IntrusiveListMemberNodeTraits<PadTegra, &PadTegra::m_InterruptBoundListNode>;

public:
    typedef nn::util::IntrusiveList<
        PadTegra, nn::util::IntrusiveListMemberNodeTraits<PadTegra, &PadTegra::m_InterruptBoundListNode>
    > InterruptBoundList;

public:
    PadTegra() NN_NOEXCEPT :
        m_Info(),
        m_Status()
    {
    }

    void SetParam(int padNumber, const PadInfo& info)
    {
        Base::SetPadNumber(padNumber);
        m_Info = info;
    }

    bool IsLinkedToInterruptBoundPadList() const NN_NOEXCEPT
    {
        return m_InterruptBoundListNode.IsLinked();
    }

    // const getter
    const PadInfo& GetInfo() const NN_NOEXCEPT { return m_Info; }

    // non-const getter
    PadStatus& GetStatus() NN_NOEXCEPT { return m_Status; }

private:
    PadInfo m_Info;
    PadStatus m_Status;
};

}}}} // nnd::gpio::tegra::detail
