﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gpio/detail/gpio_Log.h>
#include <nn/gpio/driver/gpio.h>

#include "gpioTegra_InitialConfig.h"

#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
#include <nn/spl/spl_Api.h>
#include "gpioTegra_InitialConfig-hardware.icosa.h"
#include "gpioTegra_InitialConfig-hardware.copper.h"
#include "gpioTegra_InitialConfig-hardware.iowa.h"
#include "gpioTegra_InitialConfig-hardware.hoag.h"
#include <nne/wec/wec.h>
#include "gpioTegra_WakePinSetting-hardware.nx.h"
#include "gpioTegra_InitialWakePinSetting-hardware.icosa.h"
#include "gpioTegra_InitialWakePinSetting-hardware.copper.h"
#include "gpioTegra_InitialWakePinSetting-hardware.iowa.h"
#include "gpioTegra_InitialWakePinSetting-hardware.hoag.h"
#include "gpioTegra_DisableWakePinSettingWithoutPmic-hardware.nx.h"
#endif

namespace nnd { namespace gpio { namespace tegra { namespace detail {

namespace
{

#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
nn::spl::HardwareType GetHardwareType() NN_NOEXCEPT
{
    nn::Bit64 config;
    nn::spl::Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::spl::GetConfig(&config, nn::spl::ConfigItem_HardwareType));
    nn::spl::Finalize();
    return static_cast<nn::spl::HardwareType>(config);
}
#endif

}

void SetInitialGpioConfig() NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_HARDWARE_NX)

    int                configCount;
    GpioInitialConfig* pConfigList;

    switch (GetHardwareType())
    {
    case nn::spl::HardwareType_Copper:
        pConfigList = initGpioConfigListForCopper;
        configCount = sizeof(initGpioConfigListForCopper) / sizeof(initGpioConfigListForCopper[0]);
        NN_DETAIL_GPIO_TRACE("Set Gpio Initial Config For Copper\n");
        break;

    case nn::spl::HardwareType_Iowa:
        pConfigList = initGpioConfigListForIowa;
        configCount = sizeof(initGpioConfigListForIowa) / sizeof(initGpioConfigListForIowa[0]);
        NN_DETAIL_GPIO_TRACE("Set Gpio Initial Config For Odin Mariko\n");
        break;

    case nn::spl::HardwareType_Hoag:
        pConfigList = initGpioConfigListForHoag;
        configCount = sizeof(initGpioConfigListForHoag) / sizeof(initGpioConfigListForHoag[0]);
        NN_DETAIL_GPIO_TRACE("Set Gpio Initial Config For Hoag\n");
        break;

    case nn::spl::HardwareType_Icosa:
    default: // TORIAEZU
        pConfigList = initGpioConfigListForIcosa;
        configCount = sizeof(initGpioConfigListForIcosa) / sizeof(initGpioConfigListForIcosa[0]);
        NN_DETAIL_GPIO_TRACE("Set Gpio Initial Config\n");
        break;
    }

    for (int i = 0; i < configCount; i++)
    {
        // TORIAEZU: NX で boot プロセスが gen2 をリンクする場合には実装が必要だが、今はそこまでする予定なし
        // 実装する場合は OpenSession 通さず、DriverImpl 直叩きで実現する
        // この場合 DeviceCode のリストでなく PadTegra のリストで定義して回すようにする
#if 0
        // ここは Gen1 時代の実装のコピー
        nn::gpio::driver::GpioPadSession session;
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::gpio::driver::OpenSession(&session, pConfigList[i].code));
        nn::gpio::driver::SetDirection(&session, pConfigList[i].direction);
        if (pConfigList[i].direction == nn::gpio::Direction_Output)
        {
            nn::gpio::driver::SetValue(&session, pConfigList[i].value);
        }
        nn::gpio::driver::CloseSession(&session);
#else
        NN_DETAIL_GPIO_FATAL("SetInitialGpioConfig is not implemented yet.\n");
        NN_ABORT();
#endif
    }
#else
    NN_DETAIL_GPIO_TRACE("Not set Gpio Initial Config\n");
#endif
}

void SetInitialWakePinConfig() NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
    int            configCount;
    WakePinConfig* pConfigList;

    nne::wec::Initialize();

    switch (GetHardwareType())
    {
        case nn::spl::HardwareType_Copper:
            pConfigList = initWakePinConfigListForCopper;
            configCount = sizeof(initWakePinConfigListForCopper) / sizeof(initWakePinConfigListForCopper[0]);
            break;

        case nn::spl::HardwareType_Iowa:
            pConfigList = initWakePinConfigListForIowa;
            configCount = sizeof(initWakePinConfigListForIowa) / sizeof(initWakePinConfigListForIowa[0]);
            break;

        case nn::spl::HardwareType_Hoag:
            pConfigList = initWakePinConfigListForHoag;
            configCount = sizeof(initWakePinConfigListForHoag) / sizeof(initWakePinConfigListForHoag[0]);
            break;

        case nn::spl::HardwareType_Icosa:
        default: // TORIAEZU
            pConfigList = initWakePinConfigListForIcosa;
            configCount = sizeof(initWakePinConfigListForIcosa) / sizeof(initWakePinConfigListForIcosa[0]);
            break;
    }

    for(int i = 0; i < configCount; i++)
    {
        SetWakeEventLevel(pConfigList[i].wakeEventId, pConfigList[i].level);
        SetWakeEventEnabled(pConfigList[i].wakeEventId, pConfigList[i].isWakeEventEnable);
    }

    // ソフトウェア的な Finalize は用意されていない
#else
    NN_DETAIL_GPIO_TRACE("Not set Wakepin Initial Config\n");
#endif
}

}}}} // nnd::gpio::tegra::detail
