﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/devicecode/devicecode_Predefined.gpio.h>
#include "gpioTegra_InitialConfig.h"

namespace nnd { namespace gpio { namespace tegra { namespace detail {

static struct GpioInitialConfig initGpioConfigListForCopper[] =
{
    {
        NN_DEVICECODE_GPIO_NX_5_V_STEP_DOWN_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_GAME_CARD_RESET,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_USB_SWITCH_B_2_OC,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_5_V_STEP_DOWN_PG,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_USB_SWITCH_A_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_POW_SD_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_POW_GC,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_USB_SWITCH_A_FLAG,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_USB_SWITCH_B_3_OC,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_GAME_CARD_CD,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_USB_SWITCH_B_3_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_USB_SWITCH_B_2_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_PROD_TYPE_0,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_PROD_TYPE_1,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_PROD_TYPE_2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_PROD_TYPE_3,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_TEMP_ALERT,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_BUTTON_SLEEP_2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BUTTON_VOL_UP,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_BUTTON_VOL_DN,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_RECOVERY_KEY,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_PWM_FAN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_PD_RST_N,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_SD_CD,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_SD_WP,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_BT_GPIO_2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BT_GPIO_3,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BT_GPIO_4,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_CRADLE_IRQ,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_POW_VCPU_INT,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_MAX_77621_GPU_INT,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_HDMI_5_V_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_USB_SWITCH_B_1_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_HDMI_PD_TR_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_WIFI_RF_DISABLE,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_WIFI_RESET,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_WIFI_WAKE_HOST,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_AP_WAKE_BT,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BT_RST,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BT_WAKE_AP,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BT_GPIO_5,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_FAN_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_USB_SWITCH_B_1_OC,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_HDMI_HPD,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
};

}}}} // nnd::gpio::tegra::detail
