﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_DeviceCode.h>
#include <nn/util/util_StringView.h>

#include <nn/gpio/driver/detail/dt/gpio_DeviceCodeNodeParser.h>

#include "gpioTegra_DriverImpl.h"
#include "gpioTegra_PadManager.h"

namespace nnd { namespace gpio { namespace tegra { namespace detail {

class DeviceCodeNodeParserImpl :
    public nn::gpio::driver::detail::dt::IDeviceCodeNodeParser
{
private:
    typedef nn::gpio::driver::detail::dt::IDeviceCodeNodeParser Base;

public:
    DeviceCodeNodeParserImpl(DriverImpl& driver, PadAllocator& padAllocator) NN_NOEXCEPT :
        Base({ "nvidia,tegra210-gpio" }),
        m_pDriver(&driver),
        m_PadAllocator(padAllocator)
    {}

private:
    // 各デバイスコードノードのパース開始時に呼ばれる処理
    virtual nn::Result OnCompatibleNodeBegin(nn::dt::Node node) NN_NOEXCEPT NN_OVERRIDE;

    // 各デバイスコードノードのパース終了時に呼ばれる処理（実装不要）
    // virtual void OnCompatibleNodeEnd(nn::dt::Node node) NN_NOEXCEPT NN_OVERRIDE;

    // パース中のノードに含まれるデバイスコードごとに呼ばれる処理
    // device-codes プロパティのデバイスコード列の先頭から順に呼び出します
    // デバイスコードに対応するモジュール固有のパラメータの読み出しはここに実装してください
    virtual nn::Result OnDeviceCodeFound(nn::DeviceCode deviceCode, nn::dt::Node node) NN_NOEXCEPT NN_OVERRIDE;

private:
    DriverImpl* m_pDriver{ nullptr };
    PadAllocator& m_PadAllocator;
    bool m_HasGpiosProperty{ false };
    bool m_HasNvidiaPmcWakeupProperty{ false };
    int m_PropertyGpiosIndex{ 0 }; // "gpios"
    int m_PropertyNvidiaPmcWakeupIndex{ 0 }; // "nvidia,pmc-wakeup"
};

}}}} // nnd::gpio::tegra::detail
