﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/gpio/gpio_Type.h>
#include <nn/gpio/driver/gpio_IGpioDriver.h>
#include <nn/gpio/driver/gpio_Pad.h>

//---------------------------------------------------------------------------

namespace nnd { namespace gpio { namespace skeleton { namespace detail {

class DriverImpl :
    public nn::gpio::driver::IGpioDriver
{
    NN_DDSF_CAST_SAFE_DECL;

    NN_DISALLOW_COPY(DriverImpl);
    NN_DISALLOW_MOVE(DriverImpl);

public:
    DriverImpl() NN_NOEXCEPT
    {}

    // IGpioDriver: ドライバ初期化
    virtual void InitializeDriver() NN_NOEXCEPT NN_OVERRIDE;

    // IGpioDriver: パッド制御
    virtual nn::Result GetDirection(nn::gpio::Direction* pOut, nn::gpio::driver::Pad* pPad) const NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result SetDirection(nn::gpio::driver::Pad* pPad, nn::gpio::Direction direction) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetValue(nn::gpio::GpioValue* pOut, nn::gpio::driver::Pad* pPad) const NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result SetValue(nn::gpio::driver::Pad* pPad, nn::gpio::GpioValue value) NN_NOEXCEPT NN_OVERRIDE;
};

}}}} // nnd::gpio::skeleton::detail
