﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * デバッグ用ユーティリティ
 */

#include <nn/nn_SdkLog.h>

//#define NND_BH1730FVC_DEBUG

#ifdef NND_BH1730FVC_DEBUG
#define NND_BH1730FVC_LOG(fmt, ...) \
    NN_SDK_LOG("nnd::bh1730fvc > %s(%d)\t: " fmt, __FUNCTION__, __LINE__, ##__VA_ARGS__ )

#define NND_BH1730FVC_DETAIL_LOG(fmt, ...) \
    NN_SDK_LOG("nnd::bh1730fvc::detail > %s(%d)\t: " fmt, __FUNCTION__, __LINE__, ##__VA_ARGS__ )

#define NND_BH1730FVC_LOG_RESULT(result) \
    NND_BH1730FVC_LOG( "[Failed] Module: %3d, Description: %3d, InnerValue: 0x%08x\n", \
    result.GetModule(), result.GetDescription(), result.GetInnerValueForDebug())

#else
#define NND_BH1730FVC_LOG(...)
#define NND_BH1730FVC_DETAIL_LOG(...)
#define NND_BH1730FVC_LOG_RESULT(...)

#endif
