﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief       tmp451 ライブラリの初期化と終了処理の API リストです。
 */

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/os/os_SystemEvent.h>

#include <nnd/tmp451/tmp451.h>

#include "tmp451_Types.h"

namespace nnd {
namespace tmp451 {

//! @name 初期化と終了処理
//! @{

/**
 * @brief       ドライバライブラリを初期化します。
 *
 * @return      処理の結果を返します。
 * @retval      nn::ResultSuccess
 *                   成功しました。
 * @retval      nn::i2c::Send()、nn::i2c::ExecuteCommandList()の戻り値
 *                   I2C に関するエラー(参考：@ref nn::i2c)が発生しました。
 *                   処理が完了していないため、やり直すためには再度関数を呼び直す必要があります。
 *
 * @post        Standby 状態に遷移します。
 *
 * @details     ドライバライブラリを初期化します。 @n
 *              関連するライブラリの初期化処理、デバイスのリセットが行われます。 @n
 *              デバイスの接続状態を ASSERT で確認します。
 */
nn::Result Initialize() NN_NOEXCEPT;

/**
 * @brief       ドライバライブラリの終了処理をします。
 *
 * @return      処理の結果を返します。
 * @retval      ResultSuccess
 *                  成功しました。
 * @retval      nn::i2c::Send()、nn::i2c::ExecuteCommandList()の戻り値
 *                  I2C に関するエラー(参考：@ref nn::i2c)が発生しました。
 *                  処理が完了していないため、やり直すためには再度関数を呼び直す必要があります。
 *
 *
 * @pre         初期化済み状態である必要があります。
 *
 * @post        未初期化状態に遷移します。
 *
 * @details     ドライバライブラリを終了します。 @n
 *              関連するライブラリの終了処理、デバイスのリセットが行われます。 @n
 *              デバイスのリセットが呼ばれるため、デバイス設定値はリセットされ、
 *              温度計測動作は停止します。
 */
nn::Result Finalize() NN_NOEXCEPT;

//! @}



} // tmp451
} // nnd
