﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/nn_Result.h>

typedef uint64_t nnsslSslContextId;
typedef uint64_t nnsslSslConnectionId;

static const uint32_t nnsslMaxHostNameLength       = 255; // The maximum length of host name
static const uint32_t nnsslMaxContextCount         = 8;   // The maximum number of nn::ssl::Context allowed to create
static const uint32_t nnsslMaxConnectionCount      = 8;   // The maximum number of nn::ssl::Connection allowed to create
static const uint32_t nnsslDefaultConcurrencyLimit = 2;  // The default concurrency limit

typedef struct nnsslClientContext
{
    nnsslSslConnectionId _ConnectionId; //<! Connection ID assigned when the connection is created
    nnsslSslContextId    _ContextId;    //<! Context ID which is associated with the connection
    nnResult             _IoLastError;  //<! Last error of I/O API
} nnsslClientContext;
