﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Bluetooth デバイス設定に関する API の宣言
 */

#pragma once

#include <nnc/nn_Common.h>

/**
 * @brief       Bluetooth デバイス設定の最大数
 */
static const int nnsettingssystemBluetoothDevicesSettingsCountMax = 10;

/**
 * @brief       Bluetooth デバイス設定を表す構造体です。
 */
typedef struct nnsettingssystemBluetoothDevicesSettings
{
    uint8_t  bd_addr[6];           // 0-5
    char     device_name[32];      // 6-37
    uint8_t  class_of_device[3];   // 38-40
    uint8_t  link_key[16];         // 41-56
    uint8_t  link_key_present;     // 57
    uint16_t version;              // 58-59
    uint32_t trusted_services;     // 60-63
    uint16_t vid;                  // 64-65
    uint16_t pid;                  // 66-67
    uint8_t  sub_class;            // 68
    uint8_t  attribute_mask;       // 69
    uint16_t descriptor_length;    // 70-71
    uint8_t  descriptor[128];      // 72-199
    uint8_t  key_type;             // 200
    uint8_t  device_type;          // 201
    uint16_t brr_size;             // 202-203
    uint8_t  brr[9];               // 204-212
    uint8_t  reserved[299];        // 213-511 reserved for future use
} nnsettingssystemBluetoothDevicesSettings;
