﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   GPIO ドライバで使用する enum 定義
 */

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/os/os_SystemEvent.h>

#include <nn/gpio/detail/gpio_Gen.h>

#if defined(NN_DETAIL_GPIO_ENABLE_GEN_1)
#include <nnc/gpio/gpio_PadMap.h>
#endif

//--------------------------------------------------------------------------
//  C/C++ 共通の宣言・定義
//--------------------------------------------------------------------------

#ifdef __cplusplus
extern "C"
{
#endif // ifdef __cplusplus

/**
* @brief 割り込みモードの列挙型です。
*
* @see
*  nn::gpio::InterruptMode
*/
typedef enum nngpioInterruptMode
{
    nngpioInterruptMode_LowLevel = 0,   //!< GPIO パッドの入力が L であるときに割り込みが入ります。
    nngpioInterruptMode_HighLevel,      //!< GPIO パッドの入力が H であるときに割り込みが入ります。
    nngpioInterruptMode_RisingEdge,     //!< GPIO パッドの入力が立ち上がりエッジの変化が起きた際に割り込みが発生します。
    nngpioInterruptMode_FallingEdge,    //!< GPIO パッドの入力が立ち下がりエッジの変化が起きた際に割り込みが発生します。
    nngpioInterruptMode_AnyEdge,        //!< GPIO パッドの入力変化が起きた際に割り込みが発生します。
} nngpioInterruptMode;

/**
* @brief GPIO パッドの入出力方向の列挙型です。
*
* @see
*  nn::gpio::Direction
*/
typedef enum nngpioDirection
{
    nngpioDirection_Input = 0,     //!< 入力方向
    nngpioDirection_Output,        //!< 出力方向
} nngpioDirection;

/**
* @brief GPIO パッドの値の列挙型です。
*
* @see
*  nn::gpio::GpioValue
*/
typedef enum nngpioGpioValue
{
    nngpioGpioValue_Low = 0,    //!< Low
    nngpioGpioValue_High,       //!< High
} nngpioGpioValue;

/**
* @brief GPIO パッドの割り込みステータスの列挙型です。
*
* @see
*  nn::gpio::InterruptStatus
*/
typedef enum nngpioInterruptStatus
{
    nngpioInterruptStatus_Inactive = 0,  //!< 割り込み発生なし
    nngpioInterruptStatus_Active,        //!< 割り込み発生
} nngpioInterruptStatus;


#ifdef __cplusplus
}
#endif // ifdef __cplusplus
