﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   GPIO ドライバのパッドアクセス機能の API 宣言(C リンケージ向けインタフェース)
 */

#pragma once

#include <nnc/nn_Common.h>

//--------------------------------------------------------------------------
//  C/C++ 共通の宣言・定義
//--------------------------------------------------------------------------

#ifdef __cplusplus
extern "C"
{
#endif // ifdef __cplusplus

struct nngpioGpioPadSession;
typedef nngpioGpioPadSession nngpioGpioPadSession;

//! @name 初期化と終了処理
//! @{

/**
 * @brief 開発目的で使用するための特定パッドを直接指定して GPIO パッドとのセッションをオープンする API です。
 *
 * @param[in]   pOutSession            GPIO パッドのセッション用パラメータ
 * @param[in]   padNumber              アクセス対象の GPIO パッドの番号
 * @details
 *  この関数は、@ref nnc::gpio::OpenSessionForDev() の C リンケージ向けインタフェースです。
 *  詳細は C++ 向け版を参照してください。
 *
 * @see
 *  nn::gpio::OpenSession()
 */
void nngpioOpenSessionForDev(nngpioGpioPadSession* pOutSession, int padNumber);


//! @}
// ~初期化と終了処理

#ifdef __cplusplus
}
#endif // ifdef __cplusplus
