﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   GPIO ドライバライブラリの API 宣言。
 */

#pragma once

#include <nnc/nn_Common.h>

//--------------------------------------------------------------------------
//  C/C++ 共通の宣言・定義
//--------------------------------------------------------------------------

#ifdef __cplusplus
extern "C"
{
#endif // ifdef __cplusplus

//! @name ライブラリの初期化・終了
//! @{

/**
 * @brief   GPIO ドライバライブラリを初期化します。
 *
 * @details
 *  この関数は、@ref nn::gpio::Initialize() の C リンケージ向けインタフェースです。
 *  詳細は C++ 向け版を参照してください。
 *
 * @see
 *  nn::gpio::Initialize()
 */
void nngpioInitialize();

/**
 * @brief GPIO ドライバライブラリを終了します。
 *
 * @details
 *  この関数は、@ref nn::gpio::Finalize() の C リンケージ向けインタフェースです。
 *  詳細は C++ 向け版を参照してください。
 *
 * @see
 *  nn::gpio::Finalize()
 */
void nngpioFinalize();

//! @}

#ifdef __cplusplus
}
#endif // ifdef __cplusplus
