﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nnc/dns/parser/dns_ParserDependencies.h>
#include <nnc/dns/parser/dns_ParserCommon.h>

struct nndnsparserQuestionIterator
{
    const struct nndnsparserMessage* pMessage;
    struct nndnsparserMemoryBlock section;
    const uint8_t* pCurrent;
    uint8_t count;
    struct nndnsparserQuestion current;
};

int nndnsparserQuestionIteratorInitialize(struct nndnsparserQuestionIterator* pIterator,
                                          const struct nndnsparserMessage* pMessage,
                                          enum nndnsparserMessageSectionConstant section);

int nndnsparserQuestionIteratorGetNext(struct nndnsparserQuestionIterator* pIiterator);
