﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nnc/dns/parser/dns_ParserDependencies.h>
#include <nnc/dns/parser/dns_ParserCommon.h>

struct nndnsparserLabel
{
    const struct nndnsparserMessage* pMessage;
    struct nndnsparserMemoryBlock range;
    size_t dirtySize;
    const uint8_t* data;
};

void nndnsparserLabelInitialize(struct nndnsparserLabel* pLabel,
                                const struct nndnsparserMessage* pMessage);
ssize_t nndnsparserLabelSizeOf(const struct nndnsparserLabel* pLabel);

ssize_t nndnsparserLabelGetStringBufferSize(const struct nndnsparserLabel* pLabel);

bool nndnsparserLabelIsEqual(const struct nndnsparserLabel* pLabel1,
                             const struct nndnsparserLabel* pLabel2);

ssize_t nndnsparserLabelFromBuffer(struct nndnsparserLabel* pLabel,
                                   const uint8_t* pBuffer,
                                   size_t left);

ssize_t nndnsparserLabelToBuffer(uint8_t * const pBuffer,
                                 size_t left,
                                 const struct nndnsparserLabel* pLabel);

ssize_t nndnsparserLabelToBufferFromDomainNameString(uint8_t * const pBuffer,
                                                     size_t bufferSize,
                                                     const char* pString);

ssize_t nndnsparserLabelToBufferFromHostnameString(uint8_t * const pBuffer,
                                                   size_t bufferSize,
                                                   const char* pString);

ssize_t nndnsparserLabelToString(char* pString,
                                 size_t size,
                                 const struct nndnsparserLabel* pLabel);
