﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nnc/dns/parser/dns_ParserDependencies.h>
#include <nnc/dns/parser/dns_ParserCommon.h>

struct nndnsparserHeader
{
    const struct nndnsparserMessage* pMessage;
    struct nndnsparserMemoryBlock range;
    size_t dirtySize;
    uint16_t transactionId;
    uint16_t flags;
    uint16_t questionCount;
    uint16_t answerCount;
    uint16_t authorityCount;
    uint16_t additionalCount;
};

void nndnsparserHeaderInitialize(struct nndnsparserHeader* pHeader,
                                 const struct nndnsparserMessage* pMessage);
ssize_t nndnsparserHeaderSizeOf(const struct nndnsparserHeader* pHeader);

bool nndnsparserHeaderIsEqual(const struct nndnsparserHeader* pHeader1,
                              const struct nndnsparserHeader* pHeader2);

ssize_t nndnsparserHeaderFromBuffer(struct nndnsparserHeader* pHeader,
                                    const uint8_t* pBuffer,
                                    size_t size);

ssize_t nndnsparserHeaderToBuffer(uint8_t * const pBuffer,
                                  size_t left,
                                  const struct nndnsparserHeader* pHeader);
