﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

enum nndnsparserLibraryConstant
{
    nndnsparserLibraryConstant_InaddrArpaStringBufferSize = 29,
    nndnsparserLibraryConstant_ObjectIsDirty = 0,
    nndnsparserLibraryConstant_HostnameMaxStringLength = 63,
    nndnsparserLibraryConstant_DomainNameMaxStringLength = 253,
};

enum nndnsparserHeaderConstant
{
    nndnsparserHeaderConstant_Size = 12,
};

enum nndnsparserHeaderFlagsConstant
{
    nndnsparserHeaderFlagsConstant_True = 1,
    nndnsparserHeaderFlagsConstant_False = 0,
    nndnsparserHeaderFlagsConstant_ResponseCodeShift = 0,
    nndnsparserHeaderFlagsConstant_ResponseCodeMask = 15,
    nndnsparserHeaderFlagsConstant_IsNonAuthenticatedAcceptableShift = 4,
    nndnsparserHeaderFlagsConstant_IsNonAuthenticatedAcceptableMask = 1,
    nndnsparserHeaderFlagsConstant_IsResponseAuthenticatedShift = 5,
    nndnsparserHeaderFlagsConstant_IsResponseAuthenticatedMask = 1,
    nndnsparserHeaderFlagsConstant_ZeroShift = 6,
    nndnsparserHeaderFlagsConstant_ZeroMask = 1,
    nndnsparserHeaderFlagsConstant_IsResponseRecursionAvailable = 7,
    nndnsparserHeaderFlagsConstant_IsResponseRecursionAvailableMask = 1,
    nndnsparserHeaderFlagsConstant_IsRecursionAvailableShift = 7,
    nndnsparserHeaderFlagsConstant_IsRecursionAvailableMask = 1,
    nndnsparserHeaderFlagsConstant_IsRecursionDesiredShift = 8,
    nndnsparserHeaderFlagsConstant_IsRecursionDesiredMask = 1,
    nndnsparserHeaderFlagsConstant_IsMessageTruncatedShift = 9,
    nndnsparserHeaderFlagsConstant_IsMessageTruncatedMask = 1,
    nndnsparserHeaderFlagsConstant_IsResponseAuthorativeShift = 10,
    nndnsparserHeaderFlagsConstant_IsResponseAuthorativeMask = 1,
    nndnsparserHeaderFlagsConstant_OperationCodeShift = 11,
    nndnsparserHeaderFlagsConstant_OperationCodeMask = 15,
    nndnsparserHeaderFlagsConstant_IsResponseShift = 15,
    nndnsparserHeaderFlagsConstant_IsResponseMask = 1,
};

enum nndnsparserOperationCodeConstant
{
    nndnsparserOperationCodeConstant_StandardQuery = 0,
    nndnsparserOperationCodeConstant_InverseQuery = 1,
    nndnsparserOperationCodeConstant_ServerStatus = 2,
    nndnsparserOperationCodeConstant_Notify = 3,
    nndnsparserOperationCodeConstant_Update = 5,
};

enum nndnsparserResponseCodeConstant
{
    nndnsparserResponseCodeConstant_NoError = 0,
    nndnsparserResponseCodeConstant_FormatError = 1,
    nndnsparserResponseCodeConstant_ServerFailure = 2,
    nndnsparserResponseCodeConstant_NonExistentDomain = 3,
    nndnsparserResponseCodeConstant_NotImplemented = 4,
    nndnsparserResponseCodeConstant_Refused = 5,
    nndnsparserResponseCodeConstant_YxRRSet = 7,
    nndnsparserResponseCodeConstant_NxRRSet = 8,
    nndnsparserResponseCodeConstant_NotAuthorative = 9,
    nndnsparserResponseCodeConstant_NotZone = 10,
    nndnsparserResponseCodeConstant_BadVersion = 16,
    nndnsparserResponseCodeConstant_BadSignature = 16,
    nndnsparserResponseCodeConstant_BadKey = 17,
    nndnsparserResponseCodeConstant_BadTime = 18,
    nndnsparserResponseCodeConstant_BadMode = 19,
    nndnsparserResponseCodeConstant_BadName = 20,
    nndnsparserResponseCodeConstant_BadAlgorithm = 21,
};

enum nndnsparserLabelConstant
{
    nndnsparserLabelConstant_LabelMaximumBufferSize = 1 + nndnsparserLibraryConstant_HostnameMaxStringLength,
    nndnsparserLabelConstant_StringLabelPadding = 2,
    nndnsparserLabelConstant_LabelSequenceMaximumBufferSize = nndnsparserLabelConstant_StringLabelPadding + nndnsparserLibraryConstant_DomainNameMaxStringLength,
    nndnsparserLabelConstant_TypeShift = 6,
    nndnsparserLabelConstant_TypeMask = 3,
    nndnsparserLabelConstant_LengthOffsetMask = 63,
    nndnsparserLabelConstant_OffsetLeftShift = 8,
    nndnsparserLabelConstant_TypeNormal = 0,
    nndnsparserLabelConstant_TypeCompressed = 3,
    nndnsparserLabelConstant_TypeCompressedSize = 2,
    nndnsparserLabelConstant_TypeExtended = 1,
};

enum nndnsparserClassConstant
{
    nndnsparserClassConstant_Internet = 1,
    nndnsparserClassConstant_Chaos = 3,
    nndnsparserClassConstant_Hesiod = 4,
};

enum nndnsparserTypeConstant
{
    nndnsparserTypeConstant_Address = 1,
    nndnsparserTypeConstant_Nameserver = 2,
    nndnsparserTypeConstant_CanonicalName = 5,
    nndnsparserTypeConstant_StartOfAuthority = 6,
    nndnsparserTypeConstant_Pointer = 12,
    nndnsparserTypeConstant_MailExchange = 15,
    nndnsparserTypeConstant_Text = 16,
    nndnsparserTypeConstant_ResponsiblePersons = 17,
    nndnsparserTypeConstant_AfsDb = 18,
    nndnsparserTypeConstant_Signature = 24,
    nndnsparserTypeConstant_Key = 25,
    nndnsparserTypeConstant_Address6 = 28,
    nndnsparserTypeConstant_Location = 29,
    nndnsparserTypeConstant_Service = 33,
    nndnsparserTypeConstant_NamingAuthorityPointer = 35,
    nndnsparserTypeConstant_KeyExchangerRecord = 36,
    nndnsparserTypeConstant_Certificate = 37,
    nndnsparserTypeConstant_DelegationNameRecord = 39,
    nndnsparserTypeConstant_Option = 41,
    nndnsparserTypeConstant_AddressPrefixList = 42,
    nndnsparserTypeConstant_DelegationSigner = 43,
    nndnsparserTypeConstant_SshPublicKeyFingerprint = 44,
    nndnsparserTypeConstant_IpSecKey = 45,
    nndnsparserTypeConstant_DnsSecSignature = 46,
    nndnsparserTypeConstant_NextSecureRecord = 47,
    nndnsparserTypeConstant_DnsKey = 48,
    nndnsparserTypeConstant_DhcpId = 49,
    nndnsparserTypeConstant_NextSecureRecordVer3 = 50,
    nndnsparserTypeConstant_NextSecureRecordVer3Params = 51,
    nndnsparserTypeConstant_TransportLayerSecurityAuthentication = 52,
    nndnsparserTypeConstant_HostIdentityProtocol = 55,
    nndnsparserTypeConstant_ChildDelegationSigner = 59,
    nndnsparserTypeConstant_ChildDnsKey = 60,
    nndnsparserTypeConstant_OpenPgpKey = 61,
    nndnsparserTypeConstant_TransactionKey = 249,
    nndnsparserTypeConstant_TransactionSignature = 250,
    nndnsparserTypeConstant_IncrementalZoneTransfer = 251,
    nndnsparserTypeConstant_AuthorativeZoneTransfer = 252,
    nndnsparserTypeConstant_AllCachedRecords = 255,
    nndnsparserTypeConstant_UniformResourceIdentifier = 256,
    nndnsparserTypeConstant_CertificationAuthorityAuthorization = 257,
    nndnsparserTypeConstant_DnsSecTrustAuthorities = 32768,
    nndnsparserTypeConstant_DnsSecLookasideValidation = 32769,
};

enum nndnsparserMessageSectionConstant
{
    nndnsparserMessageSectionConstant_Question = 1,
    nndnsparserMessageSectionConstant_Answer = 2,
    nndnsparserMessageSectionConstant_Authority = 3,
    nndnsparserMessageSectionConstant_Additional = 4,
};

enum nndnsparserRecordConstant
{
    nndnsparserRecordConstant_DataMaximumSize = 255
};
