﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       ファームウェア更新で使用する型の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/fs/fs_File.h>

namespace nn { namespace xcd {

/**
 * @brief       ファームウェア更新中のステージを表す型です。
 */
enum FirmwareUpdateStage
{
    FirmwareUpdateStage_Download,        //!< Firmware のダウンロード中です。
    FirmwareUpdateStage_Verify,          //!< Firmware のベリファイ中です。
    FirmwareUpdateStage_Commit,          //!< Firmware を確定しています。
    FirmwareUpdateStage_Completed,       //!< Firmware の更新が完了しました。
};

/**
 * @brief       ファームウェアイメージの種類を表す型です。
 */
enum FirmwareImageType
{
    FirmwareImageType_File,             //!< ファイル形式のイメージです。
    FirmwareImageType_Memory            //!< メモリ上のイメージです。
};

/**
 * @brief       ファームウェアのバージョンを表す型です。
 */
struct BtFirmwareVersion
{
    uint8_t major;
    uint8_t minor;
};

/**
 * @brief       ファームウェアイメージを表す型です。
 */
struct FirmwareImage
{
    FirmwareImageType   imageType;          //!< ファームウェアイメージの種類です。
    nn::fs::FileHandle  fileHandle;         //!< ファームウェアイメージのファイルハンドルです。 imageType が FirmwareImageType_File のときに有効です。
    const char*         pFirmwareImage;     //!< ファームウェアイメージのメモリ領域です。 imageType が FirmwareImageType_Memory のときに有効です。
    size_t              imageSize;          //!< ファームウェアイメージのサイズです。
};

}} // namespace nn::xcd
