﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       xcd ライブラリに関係する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/xcd/xcd_Input.h>

namespace nn { namespace xcd {

//TODO: Ble OutputCommand 類の API をここに書く

/**
 * @brief       Fifty が接続されているかどうかを取得します。
 *
 * @details     Fifty は左レールのみに接続されます。
 *
 * @return      Fifty がレールに接続されている場合に true を返します。
 */
bool IsFiftyConnected() NN_NOEXCEPT;

/**
 * @brief       Fifty の入力状態を取得します。
 *
 * @return      Fifty の入力状態を取得します。 Fifty が接続されていない場合は、無入力に相当する状態が返ります。
 */
PadState GetFiftyPadState() NN_NOEXCEPT;


}} // namespace nn::xcd
