﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   WLANプロセスのステートに関する定義
 */

#pragma once

namespace nn {
namespace wlan {


/*!
 * @brief WLANプロセスのステートを示す列挙体です。
 */
enum WlanState
{
    /*!
        @brief 無線デバイスドライバー未初期状態です。WLANプロセス起動後、すぐにReadyステートへ遷移するので実質このステートを得ることはありません。@n
        特定のデバッグ状態にある場合に限り、このステートが返ることがあります。
     */
    WlanState_Stop = 0,

    /*!
        @brief 無線デバイスドライバーの初期化が行われた状態です。
               各モードをCloseModeすると、このステートに遷移します。
               このステートから、各モードにOpenModeすることが可能です。
      */
    WlanState_Ready,

    /*!
        @brief インフラストラクチャモードのアイドル状態です。
               無線アクセスポイントへの接続とスキャンが可能です。
     */
    WlanState_InfraIdle,

    /*!
        @brief インフラストラクチャモードの接続が確立された状態です。
               データフレームの送受信、無線アクセスポイントからの切断、スキャンが可能です。
     */
    WlanState_InfraSta,

    /*!
        @brief インフラストラクチャモードでスキャン中の状態です。かつ未接続状態です。
     */
    WlanState_InfraIdleScan,

    /*!
        @brief インフラストラクチャモードでスキャン中の状態です。かつ接続状態です。
     */
    WlanState_InfraStaScan,

    /*!
        @brief ローカル通信モードの親機のアイドル状態です。
               親機の開始、スキャンが可能です。
     */
    WlanState_LocalMasterIdle,

    /*!
        @brief ローカル通信モードの親機でBSSを展開している状態です。
               データフレームの送受信、子機の切断が可能です。
     */
    WlanState_LocalMasterBss,

    /*!
        @brief ローカル通信モードの親機でスキャン中の状態です。かつBSSを展開していない状態です。
     */
    WlanState_LocalMasterIdleScan,

    /*!
        @brief ローカル通信モードの親機でスキャン中の状態です。かつBSSを展開している状態です。
     */
    WlanState_LocalMasterBssScan,

    /*!
        @brief ローカル通信モードの子機のアイドル状態です。
                 親機への接続、スキャンが可能です。
     */
    WlanState_LocalClientIdle,

    /*!
        @brief ローカル通信モードの子機で、親機との接続が確立された状態です。
               データフレームの送受信、Masterからの切断、スキャンが可能です。
     */
    WlanState_LocalClient,

    /*!
        @brief ローカル通信モードの子機でスキャン中の状態です。かつ未接続状態です。
     */
    WlanState_LocalClientIdleScan,

    /*!
        @brief ローカル通信モードの子機でスキャン中の状態です。かつ接続状態です。
     */
    WlanState_LocalClientScan,

    /*!
        @brief ローカル通信モードの観戦子機のアイドル状態です。
               親機への同期、スキャンが可能です。
     */
    WlanState_LocalSpectatorIdle,

    /*!
        @brief ローカル通信モードの観戦子機で、親機との同期が確立された状態です。
       Broadcastデータフレームの受信、同期解除、スキャンが可能です。
     */
    WlanState_LocalSpectator,

    /*!
        @brief ローカル通信モードの観戦子機でスキャン中です。かつ未同期状態です。
     */
    WlanState_LocalSpectatorIdleScan,

    /*!
        @brief ローカル通信モードの観戦子機でスキャン中です。かつ同期状態です。
     */
    WlanState_LocalSpectatorScan,

    /*!
        @brief ローカル通信Lcsモードの親機のアイドル状態です。
               親機の開始、スキャンが可能です。
     */
    WlanState_LocalLcsMasterIdle,

    /*!
        @brief ローカル通信Lcsモードの親機でBSSを展開している状態です。
               データフレームの送受信、子機の切断が可能です。
     */
    WlanState_LocalLcsMasterBss,

    /*!
        @brief ローカル通信Lcsモードの親機でスキャン中の状態です。かつBSSを展開していない状態です。
     */
    WlanState_LocalLcsMasterIdleScan,

    /*!
        @brief ローカル通信Lcsモードの親機でスキャン中の状態です。かつBSSを展開している状態です。
     */
    WlanState_LocalLcsMasterBssScan,

    /*!
        @brief ローカル通信Lcsモードの子機のアイドル状態です。
                 親機への接続、スキャンが可能です。
     */
    WlanState_LocalLcsClientIdle,

    /*!
        @brief ローカル通信Lcsモードの子機で、親機との接続が確立された状態です。
               データフレームの送受信、Masterからの切断、スキャンが可能です。
     */
    WlanState_LocalLcsClient,

    /*!
        @brief ローカル通信Lcsモードの子機でスキャン中の状態です。かつ未接続状態です。
     */
    WlanState_LocalLcsClientIdleScan,

    /*!
        @brief ローカル通信Lcsモードの子機でスキャン中の状態です。かつ接続状態です。
     */
    WlanState_LocalLcsClientScan,

    /*!
        @brief すれちがい通信モード非通信状態です。
     */
    WlanState_DetectIdle,

    /*!
        @brief すれちがい通信モード通信状態です。
     */
    WlanState_Detect,

    /*!
        @brief スリープ状態です。
     */
    WlanState_Sleep,

    //! EXITステート。プロセス終了時に遷移するステートです。
    WlanState_Exit,

    WlanState_Num
};



} // end of namespace wlan
} // end of namespace nn

