﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief Cruiser起動引数が共通で利用する 型 (非公開)
 */

#pragma once

namespace nn { namespace web { namespace common {

//--------------------------------------------------------------------------
/**
 * @brief ShimVersionです。
 *        LAのMajorVersionとして扱います。
 */
static const uint16_t ShimVersion = 5;

//--------------------------------------------------------------------------
/**
 * @brief ShimKind
 */
enum class ShimKind
{
    None,      //!<
    Ec,        //!< Ec用Shim
    Login,     //!< Login用Shim
    Offline,   //!< Offline用Shim
    Share,     //!< Share用Shim
    Web,       //!< Web用Shim
    Wifi,      //!< Wifi用Shim
    Lobby,     //!< Lobby用Shim
    Max        //!< 列挙子の総数です。
};

//--------------------------------------------------------------------------
/**
 * @brief 背景種類
 */
enum class BackgroundKind : uint32_t
{
    Normal,                  //!< 通常
    ApplicationCapture,      //!< 呼び出しアプリ画像
    ApplicationCaptureBlur,  //!< 呼び出しアプリ画像(ぼかし)
    Max,                     //!< 列挙子の総数です。
};

//--------------------------------------------------------------------------
/**
 * @brief 左スティックモード
 */
enum class LeftStickMode : uint32_t
{
    StickPointer, //!< スティックポインター
    SpatialNavi,  //!< 空間ナビ
    Max           //!< 列挙子の総数です。
};

//--------------------------------------------------------------------------
/**
 * @brief 起動画面種類
 */
enum class BootDisplayKind : uint32_t
{
    Default,           //!< 既定の動作
    White,             //!< 白画面
    Black,             //!< 黒画面
    CallerCapture,     //!< 呼び出し元画像
    CallerCaptureBlur, //!< 呼び出し元ボカシ画像
    Max,               //!< 列挙子の総数です。
};

//--------------------------------------------------------------------------
/**
 * @brief フッター表示の制御方法種類
 */
enum class FooterFixedKind : uint32_t
{
    Auto,              //!< 自動で表示と非表示を切替
    Shown,             //!< 常に表示
    Max,               //!< 列挙子の総数です。
};

//--------------------------------------------------------------------------
/**
 * @brief 画像投稿の成否を表す定数です。
 */
enum class PostResult : uint32_t
{
    Success,  //!< 投稿に成功した。
    Cancel,   //!< 投稿がキャンセルされた。
    Error,    //!< 投稿に失敗した。
    Max       //!< 列挙子の総数です。
};

//--------------------------------------------------------------------------
/**
 * @brief 終了理由
 */
enum class ExitReason : uint32_t
{
    EndButtonPressed = 0,                         //!< 「おわる」ボタンが押された。
    BackButtonPressed = 1,                        //!< 「戻る」ボタンが押された。
    ExitMessage = 2,                              //!< システムからの終了メッセージを受け取りました。
    CallbackUrlReached = 3,                       //!< コールバックURLに到達した。
    LastWindowDeleted = 4,                        //!< 最後のウインドウが削除された。
    LocalNetworkDisconnectionDenied = 5,          //!< ローカル通信の切断確認が許可されなかった
    MediaPlayerClosed = 6,                        //!< メディアプレイヤーが閉じられた。
    CausedByWebPage = 7,                          //!< ウェブページから終了要求があり終了された。
    UserSelectionCanceled = 8,                    //!< ユーザー選択がキャンセル操作で閉じられた。
    NetworkConnectionFailed = 9,                  //!< ネットワーク接続に失敗した。
    SystemUpdateRequired = 10,                    //!< 本体更新が必要とされた。
    SnsPostRestrictedByParentalControl = 11,      //!< SNS 投稿がペアレンタルコントロールによって制限されていた。
    IllegalArgument = 12,                         //!< 不正な引数が指定された。
    PlayingVideoRestrictedByParentalControl = 13, //!< 動画の再生がペアレンタルコントロールによって制限されていた。
    ClosedBySystem = 18,                          //!< システム上の終了条件により終了された。
    LibraryAppletLaunched = 19,                   //!< ライブラリアプレットを起動するために終了した。
    Unexpected = 20                               //!< 想定外の要因で終了した。
};

//--------------------------------------------------------------------------
/**
 * @brief フッターボタンの種類を表すIDです。
 */
enum class FooterButtonId : uint32_t
{
    None,           //!<
    A,              //!< A ボタン。
    B,              //!< B ボタン。
    X,              //!< X ボタン。
    StickLPress,    //!< L スティック押込み。
    StickR,         //!< R スティック。
    StartAndSelect, //!< + 、- ボタン。
    Max             //!< 列挙子の総数です。
};

//--------------------------------------------------------------------------
/**
 * @brief 起動時のフッターボタンの表示・非表示設定を表す構造体です。
 */
struct BootFooterButtonVisibleSetting
{
    FooterButtonId footerButtonId;  //!< フッターボタンの種類
    bool visible;                   //!< フッターボタンを表示するかどうか
};

//--------------------------------------------------------------------------
/**
 * @brief フッターボタンの起動時の表示・非表示を指定できる最大数
 */
static const int BootFooterButtonVisibleSettingListSize = 16;

//--------------------------------------------------------------------------
/**
 * @brief 起動時の各フッターボタンの表示・非表示設定を格納する構造体です。
 */
struct BootFooterButtonVisibleSettingList
{
    BootFooterButtonVisibleSetting settings[BootFooterButtonVisibleSettingListSize];
};

}}} // namespace nn::web::common
