﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines RGB ranges used on displays.
 */

#pragma once

namespace nn { namespace vi {

    /**
     * @brief RGB ranges available on displays.
     */
    enum RgbRange
    {
        RgbRange_Auto,    //!< Autodetect the RGB range.
        RgbRange_Limited, //!< Use clamped [16, 235] RGB range.
        RgbRange_Full,    //!< Use full [0, 255] RGB range.
        RgbRange_Max,     //!< The number of valid RGB ranges defined.
    };

}}
