﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines power states that may be supported by displays.
 */

#pragma once

namespace nn { namespace vi {

    /**
     * @brief Possible power states for displays.
     */
    enum PowerState
    {
        PowerState_Off,   //!< The display is powered off.
        PowerState_Blank, //!< The display is turned on, but not scanning content.
        PowerState_On,    //!< The display is powered on.
    };

}}
