﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines constants for layer stacks.
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace vi {

    /**
     * @brief Layer stack IDs.
     */
    enum LayerStack
    {
        LayerStack_Default             = 0,  //!< The default layer stack for all layers.
        LayerStack_Lcd                 = 1,  //!< The layer stack for LCD-only layers.
        LayerStack_Screenshot          = 2,  //!< Layer stack for screen shots initiated by the user.
        LayerStack_Recording           = 3,  //!< Layer stack for recording videos.
        LayerStack_LastFrame           = 4,  //!< Layer stack for capturing the last frame during applet transitions.
        LayerStack_Arbitrary           = 5,  //!< Layer stack for capturing an arbitrary layer by am.
        LayerStack_ApplicationForDebug = 6,  //!< Layer stack for capturing an application layer.
        LayerStack_Null                = 10, //!< Layer stack for the null display.
    };

    struct LayerStackFlags
    {
        typedef nn::util::BitFlagSet<32, LayerStackFlags>::Flag<LayerStack_Default>             Default;
        typedef nn::util::BitFlagSet<32, LayerStackFlags>::Flag<LayerStack_Lcd>                 Lcd;
        typedef nn::util::BitFlagSet<32, LayerStackFlags>::Flag<LayerStack_Screenshot>          Screenshot;
        typedef nn::util::BitFlagSet<32, LayerStackFlags>::Flag<LayerStack_Recording>           Recording;
        typedef nn::util::BitFlagSet<32, LayerStackFlags>::Flag<LayerStack_LastFrame>           LastFrame;
        typedef nn::util::BitFlagSet<32, LayerStackFlags>::Flag<LayerStack_Arbitrary>           Arbitrary;
        typedef nn::util::BitFlagSet<32, LayerStackFlags>::Flag<LayerStack_ApplicationForDebug> ApplicationForDebug;
        typedef nn::util::BitFlagSet<32, LayerStackFlags>::Flag<LayerStack_Null>                Null;
    };

    typedef nn::util::BitFlagSet<32, LayerStackFlags> LayerStackSet;

    typedef std::uint32_t LayerStackFlagType;

    static const LayerStackFlagType ValidLayerStackFlags =
        (1 << LayerStack_Default) |
        (1 << LayerStack_Lcd) |
        (1 << LayerStack_Screenshot) |
        (1 << LayerStack_Recording) |
        (1 << LayerStack_LastFrame) |
        (1 << LayerStack_Arbitrary) |
        (1 << LayerStack_ApplicationForDebug) |
        (1 << LayerStack_Null);

}}
