﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief Defines for tracking framebuffer status.
 */

#include <cstdint>
#include <nn/vi/vi_FramebufferStatus.h>
#include <nn/os/os_TickTypes.h>

namespace nn { namespace vi {

    /**
     * @brief Contains framebuffer status information.
     *
     * @details Applications should check the status member to determine
     *          what fields are available:
     *
     *          FramebufferStatus_Uninitialized: No fields are valid.
     *          FramebufferStatus_Available: All fields are valid.
     *          FramebufferStatus_Acquired: No fields are valid.
     *          FramebufferStatus_Enqueued: frameNumber and enqueueTime are valid.
     *          FramebufferStatus_Presenting: All fields are valid.
     *
     *          Values of unavailable fields are undefined.
     */
    struct FramebufferInfo
    {
        std::uint64_t frameNumber;     //!< A frame's unique identifier that is generated at queue time.
                                       //!< This is a monotonic increasing value.
        nn::os::Tick enqueueTime;      //!< Timestamp when the framebuffer was queued by the application.
        nn::os::Tick presentationTime; //!< Timestamp when the framebuffer was presented on the display.
        FramebufferStatus status;      //!< The framebuffer's current status.
    };
}}

